/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.ImmersiveHitboxesInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.platform.Platform;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmersiveHitboxes
extends AbstractImmersive<ImmersiveHitboxesInfo> {
    private static final double backpackHeight = 0.625;
    private int backpackCooldown = 0;

    public ImmersiveHitboxes() {
        super(1);
        this.forceDisableItemGuide = true;
        this.forceTickEvenIfNoTrack = true;
    }

    @Override
    protected void doTick(ImmersiveHitboxesInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (ActiveConfig.reachBehindBackpack) {
            Vec3 centerPos = Minecraft.m_91087_().f_91074_.m_20182_().m_82520_(0.0, 1.0625, 0.0);
            Vec3 headLook = VRPluginVerify.clientInVR() && VRPlugin.API.playerInVR((Player)Minecraft.m_91087_().f_91074_) && !Platform.isDevelopmentEnvironment() ? VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getHMD().getLookAngle() : Minecraft.m_91087_().f_91074_.m_20154_();
            headLook = headLook.m_82542_(1.0, 0.0, 1.0).m_82541_();
            centerPos = centerPos.m_82549_(headLook.m_82490_(-0.25));
            info.setHitbox(0, AABB.m_165882_((Vec3)centerPos, (double)Math.max(Math.abs(headLook.f_82481_) * 0.5, 0.25), (double)0.625, (double)Math.max(Math.abs(headLook.f_82479_) * 0.5, 0.25)));
        } else {
            info.setHitbox(0, null);
        }
        if (this.backpackCooldown > 0) {
            --this.backpackCooldown;
        }
    }

    @Override
    public boolean shouldRender(ImmersiveHitboxesInfo info, boolean isInVR) {
        return true;
    }

    @Override
    protected void render(ImmersiveHitboxesInfo info, PoseStack stack, boolean isInVR) {
        AABB backpackHitbox = info.getHitbox(0);
        if (backpackHitbox != null) {
            this.renderHitbox(stack, backpackHitbox, backpackHitbox.m_82399_());
        }
    }

    @Override
    public boolean enabledInConfig() {
        return true;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(ImmersiveHitboxesInfo info, int slotNum) {
        return false;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return false;
    }

    @Override
    public void trackObject(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveHitboxes;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return false;
    }

    @Override
    protected void initInfo(ImmersiveHitboxesInfo info) {
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        if (closest == 0 && hand == InteractionHand.OFF_HAND && this.backpackCooldown <= 0) {
            ClientUtil.openBag(player);
            this.backpackCooldown = 50;
        }
    }

    @Override
    public BlockPos getLightPos(ImmersiveHitboxesInfo info) {
        return info.getBlockPosition();
    }

    public void initImmersiveIfNeeded() {
        if (this.infos.size() == 0) {
            this.infos.add(new ImmersiveHitboxesInfo());
        }
    }
}

