/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractWorldStorageImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import com.hammy275.immersivemc.client.immersive.info.EnchantingInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.GetEnchantmentsPacket;
import com.hammy275.immersivemc.common.network.packet.InteractPacket;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ImmersiveETable
extends AbstractWorldStorageImmersive<EnchantingInfo> {
    private static final Map<Enchantment, Integer> fakeEnch = new HashMap<Enchantment, Integer>();
    protected final float[] yOffsets;
    protected int noInfosCooldown = 0;

    public ImmersiveETable() {
        super(1);
        float i;
        ArrayList<Float> yOffsets = new ArrayList<Float>();
        float max = 0.25f;
        for (i = 0.0f; i <= max; i += max / 20.0f) {
            yOffsets.add(Float.valueOf(i - max / 2.0f));
        }
        for (i = 0.25f; i >= 0.0f; i -= max / 20.0f) {
            yOffsets.add(Float.valueOf(i - max / 2.0f));
        }
        this.yOffsets = new float[yOffsets.size()];
        for (int i2 = 0; i2 < yOffsets.size(); ++i2) {
            this.yOffsets[i2] = ((Float)yOffsets.get(i2)).floatValue();
        }
    }

    @Override
    protected void doTick(EnchantingInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = 1; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition().m_142082_(x, y, z)).m_60795_()) continue;
                    info.areaAboveIsAir = false;
                    return;
                }
            }
        }
        info.areaAboveIsAir = true;
        for (int i = 0; i < info.yOffsetPositions.length; ++i) {
            int n = i;
            info.yOffsetPositions[n] = info.yOffsetPositions[n] + 1;
            if (info.yOffsetPositions[n] < this.yOffsets.length) continue;
            info.yOffsetPositions[i] = 0;
        }
        float hitboxSize = 0.21f;
        Vec3 inp = Vec3.m_82514_((Vec3i)info.getBlockPosition(), (double)1.25);
        info.setPosition(0, inp.m_82549_(this.getYDiffFromOffset(info, 0)));
        info.setHitbox(0, this.createHitbox(inp, hitboxSize));
        Direction facing = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        Direction rightFromMid = facing.m_122427_();
        Direction leftFromMid = facing.m_122428_();
        Vec3 midItem = inp.m_82520_(0.0, 0.5, 0.0);
        Vec3 unit = new Vec3((double)rightFromMid.m_122436_().m_123341_(), (double)rightFromMid.m_122436_().m_123342_(), (double)rightFromMid.m_122436_().m_123343_());
        Vec3 weakItem = midItem.m_82549_(unit.m_82542_(0.5, 0.5, 0.5));
        unit = new Vec3((double)leftFromMid.m_122436_().m_123341_(), (double)leftFromMid.m_122436_().m_123342_(), (double)leftFromMid.m_122436_().m_123343_());
        Vec3 strongItem = midItem.m_82549_(unit.m_82542_(0.5, 0.5, 0.5));
        info.setPosition(1, weakItem.m_82549_(this.getYDiffFromOffset(info, 1)));
        info.setPosition(2, midItem.m_82549_(this.getYDiffFromOffset(info, 2)));
        info.setPosition(3, strongItem.m_82549_(this.getYDiffFromOffset(info, 3)));
        info.setHitbox(1, this.createHitbox(weakItem, hitboxSize));
        info.setHitbox(2, this.createHitbox(midItem, hitboxSize));
        info.setHitbox(3, this.createHitbox(strongItem, hitboxSize));
        if (Minecraft.m_91087_().f_91072_ == null) {
            return;
        }
        double dist = Minecraft.m_91087_().f_91072_.m_105286_();
        info.lookingAtIndex = -1;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 start = player.m_20299_(1.0f);
        Vec3 viewVec = player.m_20252_(1.0f);
        Vec3 end = player.m_20299_(1.0f).m_82520_(viewVec.f_82479_ * dist, viewVec.f_82480_ * dist, viewVec.f_82481_ * dist);
        Optional<Integer> closest = Util.rayTraceClosest(start, end, info.getHitbox(1), info.getHitbox(2), info.getHitbox(3));
        closest.ifPresent(targetSlot -> {
            info.lookingAtIndex = targetSlot;
        });
        if (info.ticksActive % 8 == 0) {
            Network.INSTANCE.sendToServer((Object)new GetEnchantmentsPacket(info.getBlockPosition()));
        }
    }

    @Override
    public BlockPos getLightPos(EnchantingInfo info) {
        return info.getBlockPosition().m_7494_();
    }

    @Override
    public boolean shouldRender(EnchantingInfo info, boolean isInVR) {
        return Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && info.readyToRender();
    }

    @Override
    protected void render(EnchantingInfo info, PoseStack stack, boolean isInVR) {
        float renderSize;
        float itemSize = 0.42f / (float)info.getItemTransitionCountdown();
        if (!info.itemEnchantedCopy.m_41619_()) {
            for (int i = 0; i <= 2; ++i) {
                EnchantingInfo.ETableInfo enchInfo = i == 0 ? info.weakInfo : (i == 1 ? info.midInfo : info.strongInfo);
                float renderSize2 = info.slotHovered == i + 1 ? itemSize * 1.25f : itemSize;
                this.renderItem(info.itemEnchantedCopy, stack, info.getPosition(i + 1), renderSize2, this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_), info.getHitbox(i + 1), false, info.light);
                if (info.lookingAtIndex != i) continue;
                if (enchInfo.isPresent()) {
                    this.renderText((Component)new TextComponent(enchInfo.levelsNeeded + " (" + (i + 1) + ")"), stack, info.getPosition(i + 1).m_82520_(0.0, 0.33, 0.0), info.light);
                    this.renderText(enchInfo.textPreview, stack, info.getPosition(i + 1).m_82520_(0.0, -0.33, 0.0), info.light);
                    continue;
                }
                this.renderText((Component)new TranslatableComponent("immersivemc.immersive.etable.no_ench"), stack, info.getPosition(i + 1).m_82520_(0.0, -0.2, 0.0), info.light);
            }
        }
        float f = renderSize = info.slotHovered == 0 ? itemSize * 1.25f : itemSize;
        if (info.items[0] != null && !info.items[0].m_41619_()) {
            this.renderItem(info.items[0], stack, info.getPosition(0), renderSize, this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_), info.getHitbox(0), false, info.light);
        } else {
            this.renderHitbox(stack, info.getHitbox(0), info.getPosition(0));
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useETableImmersion;
    }

    @Override
    public void processStorageFromNetwork(AbstractWorldStorageInfo infoRaw, ImmersiveStorage storage) {
        EnchantingInfo info = (EnchantingInfo)infoRaw;
        info.items[0] = storage.items[0];
        if (storage.items[0] != null && !storage.items[0].m_41619_()) {
            info.itemEnchantedCopy = storage.items[0].m_41720_() == Items.f_42517_ ? new ItemStack((ItemLike)Items.f_42690_) : storage.items[0].m_41777_();
            EnchantmentHelper.m_44865_(fakeEnch, (ItemStack)info.itemEnchantedCopy);
        } else {
            info.itemEnchantedCopy = ItemStack.f_41583_;
        }
    }

    @Override
    public EnchantingInfo getNewInfo(BlockPos pos) {
        return new EnchantingInfo(pos, this.getTickTime());
    }

    @Override
    public int getTickTime() {
        return 1200;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(EnchantingInfo info, int slotNum) {
        return info.items[0] == null || info.items[0].m_41619_();
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isEnchantingTable(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveETable;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        Network.INSTANCE.sendToServer((Object)new InteractPacket(info.getBlockPosition(), closest, hand));
    }

    protected Vec3 getYDiffFromOffset(EnchantingInfo info, int slot) {
        return new Vec3(0.0, (double)this.yOffsets[info.yOffsetPositions[slot]], 0.0);
    }

    @Override
    protected void initInfo(EnchantingInfo info) {
    }

    static {
        fakeEnch.put(Enchantments.f_44962_, (Integer)Short.MAX_VALUE);
    }
}

