/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.ChestInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import com.hammy275.immersivemc.common.network.packet.FetchInventoryPacket;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmersiveChest
extends AbstractBlockEntityImmersive<BlockEntity, ChestInfo> {
    public static final double spacing = 0.1875;
    private final double threshold = 0.03;
    public int openCloseCooldown = 0;

    public ImmersiveChest() {
        super(4);
    }

    @Override
    public void globalTick() {
        super.globalTick();
        if (this.openCloseCooldown > 0) {
            --this.openCloseCooldown;
        }
    }

    @Override
    protected void doTick(ChestInfo info, boolean isInVR) {
        BlockEntity chest;
        super.doTick(info, isInVR);
        if (info.ticksActive % 2 == 0) {
            if (info.other != null) {
                Network.INSTANCE.sendToServer((Object)new FetchInventoryPacket(info.other.m_58899_()));
            } else if (info.getBlockEntity() instanceof EnderChestBlockEntity) {
                Network.INSTANCE.sendToServer((Object)new FetchInventoryPacket(info.getBlockPosition()));
            }
        }
        BlockEntity[] chests = new BlockEntity[]{info.getBlockEntity(), info.other};
        for (int i = 0; i <= 1; ++i) {
            chest = chests[i];
            if (chest == null) continue;
            info.forward = (Direction)chest.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Vec3[] positions = this.get3x3HorizontalGrid(chest.m_58899_(), 0.1875, info.forward, false);
            float hitboxSize = 0.09166667f;
            int startTop = 9 * info.getRowNum() + 27 * i;
            int endTop = startTop + 9;
            for (int z = startTop; z < endTop; ++z) {
                Vec3 posRaw = positions[z % 9];
                info.setPosition(z, posRaw.m_82520_(0.0, -0.2, 0.0));
                info.setHitbox(z, this.createHitbox(posRaw.m_82520_(0.0, -0.2, 0.0), hitboxSize));
            }
            int startMid = 9 * info.getNextRow(info.getRowNum()) + 27 * i;
            int endMid = startMid + 9;
            for (int z = startMid; z < endMid; ++z) {
                Vec3 posRaw = positions[z % 9];
                info.setPosition(z, posRaw.m_82520_(0.0, -0.325, 0.0));
                info.setHitbox(z, null);
            }
            if (info.isTFCChest) continue;
            int startBot = 9 * info.getNextRow(info.getNextRow(info.getRowNum())) + 27 * i;
            int endBot = startBot + 9;
            for (int z = startBot; z < endBot; ++z) {
                Vec3 posRaw = positions[z % 9];
                info.setPosition(z, posRaw.m_82520_(0.0, -0.45, 0.0));
                info.setHitbox(z, null);
            }
        }
        for (int chestNum = 0; chestNum <= 1; ++chestNum) {
            Vec3 linePos;
            chest = chests[chestNum];
            if (chest == null) continue;
            Vec3 forward = Vec3.m_82528_((Vec3i)info.forward.m_122436_());
            Vec3 left = Vec3.m_82528_((Vec3i)this.getLeftOfDirection(info.forward).m_122436_());
            Vec3 frontMid = this.getTopCenterOfBlock(chest.m_58899_()).m_82549_(forward.m_82542_(0.5, 0.5, 0.5));
            if (info.isOpen) {
                linePos = frontMid.m_82549_(forward.m_82542_(-0.5, -0.5, -0.5));
                info.openClosePositions[chestNum] = linePos = linePos.m_82520_(0.0, 0.5, 0.0);
                info.openCloseHitboxes[chestNum] = new AABB(linePos.m_82549_(left.m_82542_(-0.5, -0.5, -0.5)).m_82520_(0.0, -0.25, 0.0).m_82549_(forward.m_82542_(-0.625, -0.625, -0.625)), linePos.m_82549_(left.m_82542_(0.5, 0.5, 0.5)).m_82520_(0.0, 0.25, 0.0).m_82549_(forward.m_82542_(0.625, 0.625, 0.625)));
                continue;
            }
            info.openClosePositions[chestNum] = linePos = frontMid.m_82520_(0.0, -0.375, 0.0);
            info.openCloseHitboxes[chestNum] = new AABB(linePos.m_82549_(left.m_82542_(-0.5, -0.5, -0.5)).m_82520_(0.0, -0.25, 0.0).m_82549_(forward.m_82542_(-0.15, -0.15, -0.15)), linePos.m_82549_(left.m_82542_(0.5, 0.5, 0.5)).m_82520_(0.0, 0.25, 0.0).m_82549_(forward.m_82542_(0.15, 0.15, 0.15)));
        }
        if (this.openCloseCooldown <= 0 && !ActiveConfig.rightClickChest && VRPluginVerify.clientInVR() && VRPlugin.API.apiActive((Player)Minecraft.m_91087_().f_91074_) && info.openCloseHitboxes != null) {
            boolean cond;
            Vec3 current0 = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController0().position();
            Vec3 current1 = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController1().position();
            double diff0 = current0.f_82480_ - info.lastY0;
            double diff1 = current1.f_82480_ - info.lastY1;
            if (!Util.getFirstIntersect(current0, info.openCloseHitboxes).isPresent()) {
                diff0 = 0.0;
            }
            if (!Util.getFirstIntersect(current1, info.openCloseHitboxes).isPresent()) {
                diff1 = 0.0;
            }
            if (info.isOpen) {
                cond = diff0 <= -0.03 || diff1 <= -0.03;
            } else {
                boolean bl = cond = diff0 >= 0.03 || diff1 >= 0.03;
            }
            if (cond) {
                ImmersiveChest.openChest(info);
                this.openCloseCooldown = 40;
            }
            info.lastY0 = current0.f_82480_;
            info.lastY1 = current1.f_82480_;
        }
    }

    @Override
    public BlockPos getLightPos(ChestInfo info) {
        return info.getBlockPosition().m_7494_();
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(ChestInfo info, int slotNum) {
        if (info.getBlockEntity() instanceof EnderChestBlockEntity) {
            return info.items[slotNum] == null || info.items[slotNum].m_41619_();
        }
        return super.slotShouldRenderHelpHitbox(info, slotNum);
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isChest(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveChest;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    @Override
    protected void render(ChestInfo info, PoseStack stack, boolean isInVR) {
        int i;
        float itemSize = 0.25f / (float)info.getItemTransitionCountdown();
        Direction forward = info.forward;
        if (info.isOpen) {
            float renderSize;
            boolean showCount;
            int endTop;
            int startTop;
            for (i = 0; i < 27; ++i) {
                startTop = 9 * info.getRowNum();
                endTop = startTop + 9;
                showCount = i >= startTop && i <= endTop;
                renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
                this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, forward, Direction.UP, info.getHitbox(i), showCount, -1, info.light);
            }
            if (info.other != null) {
                for (i = 27; i < 54; ++i) {
                    startTop = 9 * info.getRowNum() + 27;
                    endTop = startTop + 9 + 27;
                    showCount = i >= startTop && i <= endTop;
                    renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
                    this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, forward, Direction.UP, info.getHitbox(i), showCount, -1, info.light);
                }
            }
        }
        for (i = 0; i <= 1; ++i) {
            if (info.openCloseHitboxes[i] == null || info.openClosePositions[i] == null) continue;
            this.renderHitbox(stack, info.openCloseHitboxes[i], info.openClosePositions[i]);
        }
    }

    @Override
    public ChestInfo getNewInfo(BlockEntity tileEnt) {
        if (tileEnt instanceof ChestBlockEntity) {
            return new ChestInfo(tileEnt, Integer.MAX_VALUE, (BlockEntity)Util.getOtherChest((ChestBlockEntity)tileEnt));
        }
        if (tileEnt instanceof EnderChestBlockEntity) {
            return new ChestInfo(tileEnt, Integer.MAX_VALUE, null);
        }
        throw new IllegalArgumentException("ImmersiveChest can only track chests and ender chests!");
    }

    @Override
    public int getTickTime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean shouldRender(ChestInfo info, boolean isInVR) {
        boolean dataReady = info.forward != null && info.readyToRender();
        return !info.failRender && dataReady;
    }

    @Override
    public boolean reallyShouldTrack(BlockEntity tileEnt) {
        ChestBlockEntity other;
        if (tileEnt instanceof ChestBlockEntity && (other = Util.getOtherChest((ChestBlockEntity)tileEnt)) != null) {
            for (AbstractImmersiveInfo abstractImmersiveInfo : this.getSingleton().getTrackedObjects()) {
                ChestInfo info = (ChestInfo)abstractImmersiveInfo;
                if (info.getBlockEntity() != other) continue;
                if (info.other == null) {
                    info.failRender = true;
                    info.other = tileEnt;
                    this.doTick(info, VRPluginVerify.clientInVR());
                    info.failRender = false;
                }
                return false;
            }
        }
        return super.reallyShouldTrack(tileEnt);
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useChestImmersion;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        if (!VRPluginVerify.clientInVR() && !ActiveConfig.rightClickChest) {
            return;
        }
        if (!((ChestInfo)info).isOpen) {
            return;
        }
        Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), closest, hand));
    }

    public static ChestInfo findImmersive(BlockEntity chest) {
        Objects.requireNonNull(chest);
        for (ChestInfo info : Immersives.immersiveChest.getTrackedObjects()) {
            if (info.getBlockEntity() != chest && info.other != chest) continue;
            return info;
        }
        return null;
    }

    @Override
    public void onRemove(ChestInfo info) {
        super.onRemove(info);
        if (info.isOpen) {
            ImmersiveChest.openChest(info);
        }
    }

    @Override
    protected void initInfo(ChestInfo info) {
    }

    public static void openChest(ChestInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer((Object)new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (!info.isOpen) {
            info.remove();
        }
    }

    @Override
    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return ((ChestInfo)info).isOpen;
    }
}

