/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.BrewingInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ImmersiveBrewing
extends AbstractBlockEntityImmersive<BrewingStandBlockEntity, BrewingInfo> {
    public ImmersiveBrewing() {
        super(2);
    }

    @Override
    public BrewingInfo getNewInfo(BlockEntity tileEnt) {
        return new BrewingInfo((BrewingStandBlockEntity)tileEnt, 120);
    }

    @Override
    public int getTickTime() {
        return 120;
    }

    @Override
    public boolean shouldRender(BrewingInfo info, boolean isInVR) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        Direction forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        return ((BrewingStandBlockEntity)info.getBlockEntity()).m_58904_() != null && ((BrewingStandBlockEntity)info.getBlockEntity()).m_58904_().m_8055_(((BrewingStandBlockEntity)info.getBlockEntity()).m_58899_().m_142300_(forward)).m_60795_() && info.readyToRender();
    }

    @Override
    protected void initInfo(BrewingInfo info) {
        this.setHitboxes(info);
    }

    protected void setHitboxes(BrewingInfo info) {
        Vec3 posFuel;
        Vec3 posIngredient;
        Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        BrewingStandBlockEntity stand = (BrewingStandBlockEntity)info.getBlockEntity();
        Direction forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        Vec3 pos = this.getDirectlyInFront(forward, stand.m_58899_());
        Direction left = this.getLeftOfDirection(forward);
        Vec3 leftOffset = new Vec3((double)left.m_122436_().m_123341_() * 0.25, 0.0, (double)left.m_122436_().m_123343_() * 0.25);
        Vec3 midOffset = new Vec3((double)left.m_122436_().m_123341_() * 0.5, 0.0, (double)left.m_122436_().m_123343_() * 0.5);
        Vec3 rightOffset = new Vec3((double)left.m_122436_().m_123341_() * 0.75, 0.0, (double)left.m_122436_().m_123343_() * 0.75);
        Vec3 posLeftBottle = pos.m_82549_(leftOffset).m_82520_(0.0, 0.3333333333333333, 0.0);
        info.setPosition(0, posLeftBottle);
        double midY = ActiveConfig.autoCenterBrewing ? 0.3333333333333333 : 0.25;
        Vec3 posMidBottle = pos.m_82549_(midOffset).m_82520_(0.0, midY, 0.0);
        info.setPosition(1, posMidBottle);
        Vec3 posRightBottle = pos.m_82549_(rightOffset).m_82520_(0.0, 0.3333333333333333, 0.0);
        info.setPosition(2, posRightBottle);
        if (ActiveConfig.autoCenterBrewing) {
            posIngredient = pos.m_82549_(midOffset).m_82520_(0.0, 0.6, 0.0);
            posFuel = pos.m_82549_(midOffset).m_82520_(0.0, 0.85, 0.0);
        } else {
            posIngredient = pos.m_82549_(midOffset).m_82520_(0.0, 0.75, 0.0);
            posFuel = pos.m_82549_(leftOffset).m_82520_(0.0, 0.75, 0.0);
        }
        info.setPosition(3, posIngredient);
        info.setPosition(4, posFuel);
        float hitboxSize = 0.11111111f;
        info.setHitbox(0, this.createHitbox(posLeftBottle, hitboxSize));
        info.setHitbox(1, this.createHitbox(posMidBottle, hitboxSize));
        info.setHitbox(2, this.createHitbox(posRightBottle, hitboxSize));
        info.setHitbox(3, this.createHitbox(posIngredient, hitboxSize));
        info.setHitbox(4, this.createHitbox(posFuel, hitboxSize));
        info.lastDir = forward;
    }

    @Override
    protected void doTick(BrewingInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        Direction forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        if (forward != info.lastDir) {
            this.setHitboxes(info);
        }
    }

    @Override
    public BlockPos getLightPos(BrewingInfo info) {
        return info.getBlockPosition().m_142300_(info.lastDir);
    }

    @Override
    protected void render(BrewingInfo info, PoseStack stack, boolean isInVR) {
        Direction forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
        float itemSize = 0.33333334f / (float)info.getItemTransitionCountdown();
        for (int i = 0; i <= 4; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, forward, info.getHitbox(i), i >= 3, info.light);
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useBrewingImmersion;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isBrewingStand(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveBrewing;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        BrewingInfo infoB = (BrewingInfo)info;
        Network.INSTANCE.sendToServer((Object)new SwapPacket(((BrewingStandBlockEntity)infoB.getBlockEntity()).m_58899_(), closest, hand));
    }
}

