/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractWorldStorageImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import com.hammy275.immersivemc.client.immersive.info.BeaconInfo;
import com.hammy275.immersivemc.client.immersive.info.InfoTriggerHitboxes;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.BeaconConfirmPacket;
import com.hammy275.immersivemc.common.network.packet.InteractPacket;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.mixin.BeaconBlockEntityMixin;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmersiveBeacon
extends AbstractWorldStorageImmersive<BeaconInfo> {
    private static final double effectHitboxSize = 0.2;
    private static final double displayHitboxSize = 0.2;
    private static final ResourceLocation[] effectLocations = new ResourceLocation[]{new ResourceLocation("textures/mob_effect/speed.png"), new ResourceLocation("textures/mob_effect/haste.png"), new ResourceLocation("textures/mob_effect/resistance.png"), new ResourceLocation("textures/mob_effect/jump_boost.png"), new ResourceLocation("textures/mob_effect/strength.png")};
    private static final ResourceLocation regenerationLocation = new ResourceLocation("textures/mob_effect/regeneration.png");
    private static final ResourceLocation confirmLocation = new ResourceLocation("immersivemc", "confirm.png");
    private static final ResourceLocation addLocation = new ResourceLocation("immersivemc", "add.png");

    public ImmersiveBeacon() {
        super(1);
    }

    @Override
    protected void render(BeaconInfo info, PoseStack stack, boolean isInVR) {
        float itemSize = 0.42f / (float)info.getItemTransitionCountdown();
        this.renderItem(info.items[0], stack, info.getPosition(0), info.slotHovered == 0 ? itemSize * 1.25f : itemSize, info.lastPlayerDir.m_122424_(), null, info.getHitbox(0), false, -1, info.light);
        for (int i = 0; i < info.triggerBoxes.length; ++i) {
            if (info.triggerBoxes[i] == null) continue;
            this.renderHitbox(stack, info.triggerBoxes[i], info.triggerBoxes[i].m_82399_());
        }
        float effectSize = 0.2f / (float)info.getItemTransitionCountdown();
        for (int i = 0; i <= 4; ++i) {
            if (info.triggerBoxes[i] == null) continue;
            this.renderImage(stack, effectLocations[i], info.triggerBoxes[i].m_82399_().m_82520_(0.0, -0.05, 0.0), info.lastPlayerDir, info.triggerHitboxSlotHovered == i ? effectSize * 1.25f : effectSize, info.light);
        }
        float displaySize = 0.2f / (float)info.getItemTransitionCountdown();
        if (info.effectSelected != -1) {
            this.renderImage(stack, effectLocations[info.effectSelected], info.effectSelectedDisplayPos.m_82520_(0.0, -0.05, 0.0), info.lastPlayerDir, displaySize, info.light);
        }
        if (info.triggerBoxes[6] != null) {
            this.renderImage(stack, regenerationLocation, info.triggerBoxes[5].m_82399_().m_82520_(0.0, -0.05, 0.0), info.lastPlayerDir, info.triggerHitboxSlotHovered == 5 ? displaySize * 1.25f : displaySize, info.light);
            this.renderImage(stack, addLocation, info.triggerBoxes[6].m_82399_().m_82520_(0.0, -0.05, 0.0), info.lastPlayerDir, info.triggerHitboxSlotHovered == 6 ? displaySize * 1.25f : displaySize, info.light);
        }
        if (info.triggerBoxes[7] != null && info.isReadyForConfirmExceptPayment()) {
            if (info.isReadyForConfirm()) {
                this.renderImage(stack, confirmLocation, info.triggerBoxes[7].m_82399_().m_82520_(0.0, -0.1, 0.0), info.lastPlayerDir, info.triggerHitboxSlotHovered == 7 ? itemSize * 1.25f : itemSize, info.light);
            }
            double xMult = 0.0;
            double zMult = 0.0;
            if (this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_).m_122424_().m_122436_().m_123341_() != 0) {
                zMult = 1.0;
            } else {
                xMult = 1.0;
            }
            ImmersiveBeacon.renderHitbox(stack, AABB.m_165882_((Vec3)info.effectSelectedDisplayPos, (double)(0.2 * xMult), (double)0.2, (double)(0.2 * zMult)), info.effectSelectedDisplayPos, true, 0.0f, 1.0f, 0.0f);
            if (info.regenSelected) {
                ImmersiveBeacon.renderHitbox(stack, info.triggerBoxes[5], info.effectSelectedDisplayPos, true, 0.0f, 1.0f, 0.0f);
            } else {
                ImmersiveBeacon.renderHitbox(stack, info.triggerBoxes[6], info.effectSelectedDisplayPos, true, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    protected void setHitboxesAndPositions(BeaconInfo info) {
        block13: {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(info.getBlockPosition());
            if (!(blockEntity instanceof BeaconBlockEntity)) break block13;
            BeaconBlockEntity beacon = (BeaconBlockEntity)blockEntity;
            for (int x = -1; x <= 1; ++x) {
                for (int y = 1; y <= 2; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition().m_142082_(x, y, z)).m_60795_()) continue;
                        info.areaAboveIsAir = false;
                        return;
                    }
                }
            }
            info.areaAboveIsAir = true;
            Vec3 center = Vec3.m_82512_((Vec3i)info.getBlockPosition()).m_82520_(0.0, 1.0, 0.0);
            Direction forward = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_);
            Vec3 forwardFromBlockVec = new Vec3((double)forward.m_122436_().m_123341_(), (double)forward.m_122436_().m_123342_(), (double)forward.m_122436_().m_123343_());
            Direction left = forward.m_122427_();
            Vec3 leftVec = new Vec3((double)left.m_122436_().m_123341_(), (double)left.m_122436_().m_123342_(), (double)left.m_122436_().m_123343_());
            double itemHitboxSize = 0.42f;
            info.setPosition(0, Vec3.m_82539_((Vec3i)info.getBlockPosition()).m_82549_(forwardFromBlockVec.m_82490_(0.25).m_82549_(forwardFromBlockVec.m_82490_(itemHitboxSize / 2.0)).m_82520_(0.0, itemHitboxSize / 2.0 + 0.01, 0.0)));
            info.setHitbox(0, AABB.m_165882_((Vec3)info.getPosition(0), (double)itemHitboxSize, (double)itemHitboxSize, (double)itemHitboxSize));
            info.triggerBoxes[7] = AABB.m_165882_((Vec3)info.getPosition(0).m_82520_(0.0, itemHitboxSize / 2.0 + 0.25, 0.0), (double)itemHitboxSize, (double)itemHitboxSize, (double)itemHitboxSize);
            info.effectSelectedDisplayPos = center.m_82520_(0.0, 0.125, 0.0).m_82549_(leftVec.m_82490_(-0.3333333333333333));
            int beaconLevel = ((BeaconBlockEntityMixin)beacon).getLevels();
            if (beaconLevel > 0) {
                if (beaconLevel == 1) {
                    info.triggerBoxes[0] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.75)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[1] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.5)), (double)0.2, (double)0.2, (double)0.2);
                    for (int i = 2; i < info.triggerBoxes.length - 1; ++i) {
                        info.triggerBoxes[i] = null;
                    }
                } else if (beaconLevel == 2) {
                    info.triggerBoxes[0] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.75).m_82520_(0.0, 0.125, 0.0)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[1] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.5).m_82520_(0.0, 0.125, 0.0)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[2] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.75).m_82520_(0.0, -0.125, 0.0)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[3] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.5).m_82520_(0.0, -0.125, 0.0)), (double)0.2, (double)0.2, (double)0.2);
                    for (int i = 4; i < info.triggerBoxes.length - 1; ++i) {
                        info.triggerBoxes[i] = null;
                    }
                } else {
                    info.triggerBoxes[0] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.75).m_82520_(0.0, 0.25, 0.0)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[1] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.5).m_82520_(0.0, 0.25, 0.0)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[2] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.75)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[3] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.5)), (double)0.2, (double)0.2, (double)0.2);
                    info.triggerBoxes[4] = AABB.m_165882_((Vec3)center.m_82549_(leftVec.m_82490_(0.625).m_82520_(0.0, -0.25, 0.0)), (double)0.2, (double)0.2, (double)0.2);
                    if (beaconLevel == 4) {
                        info.triggerBoxes[5] = AABB.m_165882_((Vec3)info.effectSelectedDisplayPos.m_82549_(leftVec.m_82490_(-0.25)), (double)0.2, (double)0.2, (double)0.2);
                        info.triggerBoxes[6] = AABB.m_165882_((Vec3)info.effectSelectedDisplayPos.m_82520_(0.0, -0.25, 0.0), (double)0.2, (double)0.2, (double)0.2);
                    } else {
                        for (int i = 5; i < info.triggerBoxes.length - 1; ++i) {
                            info.triggerBoxes[i] = null;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void doTick(BeaconInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (info.lastPlayerDir != this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_).m_122424_() || Minecraft.m_91087_().f_91074_.f_19797_ % 20 == 0) {
            this.setHitboxesAndPositions(info);
        }
        info.lastPlayerDir = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_).m_122424_();
    }

    @Override
    public BlockPos getLightPos(BeaconInfo info) {
        return info.getBlockPosition().m_7494_();
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useBeaconImmersion;
    }

    @Override
    public void handleTriggerHitboxRightClick(InfoTriggerHitboxes tInfo, Player player, int hitboxNum) {
        BeaconInfo info = (BeaconInfo)tInfo;
        if (hitboxNum <= 4) {
            info.effectSelected = hitboxNum;
        } else if (hitboxNum == 7) {
            Network.INSTANCE.sendToServer((Object)new BeaconConfirmPacket(info.getBlockPosition(), info.getEffectId(), info.regenSelected ? Registry.f_122823_.m_7447_((Object)MobEffects.f_19605_) : -1));
            info.remove();
        } else {
            info.regenSelected = hitboxNum == 5;
        }
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isBeacon(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveBeacon;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    @Override
    protected void initInfo(BeaconInfo info) {
        this.setHitboxesAndPositions(info);
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        Network.INSTANCE.sendToServer((Object)new InteractPacket(info.getBlockPosition(), closest, hand));
    }

    @Override
    public void processStorageFromNetwork(AbstractWorldStorageInfo info, ImmersiveStorage storage) {
        info.items[0] = storage.items[0];
    }

    @Override
    public BeaconInfo getNewInfo(BlockPos pos) {
        return new BeaconInfo(pos);
    }

    @Override
    public int getTickTime() {
        return 1200;
    }
}

