/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.ClientUtil;
import com.hammy275.immersivemc.client.immersive.AbstractBlockEntityImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.BarrelInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.ChestShulkerOpenPacket;
import com.hammy275.immersivemc.common.network.packet.SwapPacket;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmersiveBarrel
extends AbstractBlockEntityImmersive<BarrelBlockEntity, BarrelInfo> {
    public static final double MOVE_THRESHOLD = 0.045;

    public ImmersiveBarrel() {
        super(4);
    }

    @Override
    public BarrelInfo getNewInfo(BlockEntity tileEnt) {
        return new BarrelInfo((BarrelBlockEntity)tileEnt);
    }

    @Override
    public int getTickTime() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void doTick(BarrelInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        if (info.placeItemCooldown > 0) {
            --info.placeItemCooldown;
        }
        if (info.updateHitboxes) {
            this.setHitboxes(info);
            info.updateHitboxes = false;
        }
        if (!info.isOpen && info.pullHitbox != null && VRPluginVerify.clientInVR() && VRPlugin.API.apiActive((Player)Minecraft.m_91087_().f_91074_)) {
            for (int c = 0; c <= 1; ++c) {
                Vec3 current = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController(c).position();
                if (info.lastControllerPos[c] != null && info.lastPlayerPos != null) {
                    Vec3 last = info.lastControllerPos[c];
                    Vec3 change = new Vec3(current.f_82479_ - last.f_82479_, current.f_82480_ - last.f_82480_, current.f_82481_ - last.f_82481_);
                    Vec3 playerPos = Minecraft.m_91087_().f_91074_.m_20182_();
                    Vec3 playerPosChange = new Vec3(playerPos.f_82479_ - info.lastPlayerPos.f_82479_, playerPos.f_82480_ - info.lastPlayerPos.f_82480_, playerPos.f_82481_ - info.lastPlayerPos.f_82481_);
                    change = change.m_82546_(playerPosChange);
                    Direction dir = ClientUtil.getClosestDirection(change);
                    double moveAmount = Math.max(Math.abs(change.f_82479_), Math.max(Math.abs(change.f_82480_), Math.abs(change.f_82481_)));
                    if (info.pullHitbox.m_82390_(current) && dir == info.forward && moveAmount >= 0.045) {
                        info.placeItemCooldown = 10;
                        ImmersiveBarrel.openBarrel(info);
                    }
                }
                info.lastControllerPos[c] = current;
                info.lastPlayerPos = Minecraft.m_91087_().f_91074_.m_20182_();
            }
        }
    }

    @Override
    public BlockPos getLightPos(BarrelInfo info) {
        return info.getBlockPosition().m_142300_(info.forward);
    }

    @Override
    public boolean shouldRender(BarrelInfo info, boolean isInVR) {
        return info.readyToRender();
    }

    @Override
    protected void render(BarrelInfo info, PoseStack stack, boolean isInVR) {
        float itemSize = 0.25f / (float)info.getItemTransitionCountdown();
        if (info.isOpen) {
            for (int i = 0; i < 27; ++i) {
                float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
                Direction neswDir = info.forward == Direction.UP || info.forward == Direction.DOWN ? this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_) : info.forward;
                this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, neswDir, info.forward, info.getHitbox(i), true, -1, info.light);
            }
        } else if (info.pullHitbox != null) {
            this.renderHitbox(stack, info.pullHitbox, info.pullHitbox.m_82399_());
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useBarrelImmersion;
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isBarrel(pos, state, tileEntity, level);
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveBarrel;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    protected void setHitboxes(BarrelInfo info) {
        int i;
        Vec3[] positionsRaw;
        Direction facing;
        BarrelBlockEntity barrel = (BarrelBlockEntity)info.getBlockEntity();
        info.forward = facing = (Direction)barrel.m_58900_().m_61143_((Property)BarrelBlock.f_49042_);
        Vec3[] positions = new Vec3[27];
        if (facing == Direction.UP || facing == Direction.DOWN) {
            positionsRaw = this.get3x3HorizontalGrid(info.getBlockPosition(), 0.1875);
            if (facing == Direction.DOWN) {
                for (int i2 = 0; i2 < positionsRaw.length; ++i2) {
                    positionsRaw[i2] = positionsRaw[i2].m_82520_(0.0, -1.0, 0.0);
                }
            }
            Vec3 topCenter = this.getTopCenterOfBlock(info.getBlockPosition());
            info.pullHitbox = AABB.m_165882_((Vec3)topCenter.m_82520_(-0.25, 0.15, 0.0625), (double)0.35, (double)0.5, (double)0.35);
        } else {
            positionsRaw = this.get3x3VerticalGrid(info.getBlockPosition(), 0.1875, facing);
            Vec3 forwardBotLeft = this.getDirectlyInFront(facing, info.getBlockPosition());
            Direction handleDir = facing.m_122428_();
            Vec3 handleDirVec = new Vec3((double)handleDir.m_122436_().m_123341_(), (double)handleDir.m_122436_().m_123342_(), (double)handleDir.m_122436_().m_123343_());
            Vec3 forwardVec = new Vec3((double)facing.m_122436_().m_123341_(), (double)facing.m_122436_().m_123342_(), (double)facing.m_122436_().m_123343_());
            Vec3 pos = forwardBotLeft.m_82549_(handleDirVec.m_82490_(0.75)).m_82520_(0.0, 0.5625, 0.0).m_82549_(forwardVec.m_82490_(0.15));
            double xSize = facing.m_122434_() == Direction.Axis.X ? 0.5 : 0.35;
            double zSize = facing.m_122434_() == Direction.Axis.Z ? 0.5 : 0.35;
            info.pullHitbox = AABB.m_165882_((Vec3)pos, (double)xSize, (double)0.35, (double)zSize);
        }
        int startIndex = 9 * info.getRowNum();
        float hitboxSize = 0.09166667f;
        for (i = startIndex; i < startIndex + 9; ++i) {
            positions[i] = positionsRaw[i % 9];
        }
        for (i = 0; i < info.getAllPositions().length; ++i) {
            info.setPosition(i, positions[i]);
            if (positions[i] == null) {
                info.setHitbox(i, null);
                continue;
            }
            info.setHitbox(i, this.createHitbox(positions[i], hitboxSize));
        }
    }

    @Override
    protected void initInfo(BarrelInfo info) {
        this.setHitboxes(info);
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo bInfo, Player player, int closest, InteractionHand hand) {
        BarrelInfo info = (BarrelInfo)bInfo;
        if (!info.isOpen || info.placeItemCooldown > 0) {
            return;
        }
        Network.INSTANCE.sendToServer((Object)new SwapPacket(info.getBlockPosition(), closest, hand));
    }

    @Override
    public void onRemove(BarrelInfo info) {
        if (info.isOpen) {
            ImmersiveBarrel.openBarrel(info);
        }
        super.onRemove(info);
    }

    @Override
    public boolean hitboxesAvailable(AbstractImmersiveInfo info) {
        return ((BarrelInfo)info).isOpen;
    }

    public static void openBarrel(BarrelInfo info) {
        info.isOpen = !info.isOpen;
        Network.INSTANCE.sendToServer((Object)new ChestShulkerOpenPacket(info.getBlockPosition(), info.isOpen));
        if (!info.isOpen) {
            info.remove();
        }
    }

    public static BarrelInfo findImmersive(BlockEntity barrel) {
        Objects.requireNonNull(barrel);
        for (BarrelInfo info : Immersives.immersiveBarrel.getTrackedObjects()) {
            if (info.getBlockEntity() != barrel) continue;
            return info;
        }
        return null;
    }
}

