/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.BackpackInfo;
import com.hammy275.immersivemc.client.model.BackpackCraftingModel;
import com.hammy275.immersivemc.client.model.BackpackLowDetailModel;
import com.hammy275.immersivemc.client.model.BackpackModel;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.FetchPlayerStoragePacket;
import com.hammy275.immersivemc.common.network.packet.InteractPacket;
import com.hammy275.immersivemc.common.network.packet.InventorySwapPacket;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.hammy275.immersivemc.common.util.Util;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.server.swap.Swap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Optional;
import net.blf02.vrapi.api.data.IVRData;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ImmersiveBackpack
extends AbstractImmersive<BackpackInfo> {
    public static final BackpackModel model = new BackpackModel(Minecraft.m_91087_().m_167973_().m_171103_(BackpackModel.LAYER_LOCATION));
    public static final BackpackLowDetailModel modelLowDetail = new BackpackLowDetailModel(Minecraft.m_91087_().m_167973_().m_171103_(BackpackLowDetailModel.LAYER_LOCATION));
    public static final BackpackCraftingModel craftingModel = new BackpackCraftingModel(Minecraft.m_91087_().m_167973_().m_171103_(BackpackCraftingModel.LAYER_LOCATION));
    private final double spacing = 0.375;

    public ImmersiveBackpack() {
        super(1);
        this.forceDisableItemGuide = true;
    }

    @Override
    public boolean isVROnly() {
        return true;
    }

    @Override
    protected void doTick(BackpackInfo info, boolean isInVR) {
        super.doTick(info, isInVR);
        IVRPlayer vrPlayer = VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_);
        this.calculatePositions(info, vrPlayer);
        Optional<Integer> hitboxIntersect = Util.getFirstIntersect(vrPlayer.getController0().position(), info.getAllHitboxes());
        info.slotHovered = hitboxIntersect.isPresent() ? hitboxIntersect.get() : -1;
    }

    @Override
    public BlockPos getLightPos(BackpackInfo info) {
        return new BlockPos(VRPlugin.API.getVRPlayer((Player)Minecraft.m_91087_().f_91074_).getController1().position());
    }

    public static void onHitboxInteract(Player player, BackpackInfo info, int slot) {
        if (slot <= 26) {
            Network.INSTANCE.sendToServer((Object)new InventorySwapPacket(slot + 9));
            Swap.handleInventorySwap(player, slot + 9, InteractionHand.MAIN_HAND);
        } else {
            Network.INSTANCE.sendToServer((Object)new InteractPacket("backpack", slot, InteractionHand.MAIN_HAND));
            Network.INSTANCE.sendToServer((Object)new FetchPlayerStoragePacket("backpack"));
        }
    }

    protected boolean inRange(int num, int start, int end) {
        return start <= num && num <= end;
    }

    @Override
    public boolean shouldRender(BackpackInfo info, boolean isInVR) {
        return Minecraft.m_91087_().f_91074_ != null && VRPluginVerify.hasAPI && VRPlugin.API.playerInVR((Player)Minecraft.m_91087_().f_91074_) && VRPlugin.API.apiActive((Player)Minecraft.m_91087_().f_91074_) && info.readyToRender();
    }

    @Override
    protected void render(BackpackInfo tickInfo, PoseStack stack, boolean isInVR) {
        ItemStack item;
        int i;
        boolean leftHanded = VRPlugin.API.isLeftHanded((Player)Minecraft.m_91087_().f_91074_);
        BackpackInfo renderInfo = this.getRenderInfo(tickInfo);
        for (i = 0; i <= 31; ++i) {
            AABB hitbox = renderInfo.getHitbox(i);
            this.renderHitbox(stack, hitbox, renderInfo.getPosition(i));
        }
        for (i = 0; i <= 26; ++i) {
            item = Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(i + 9);
            if (item.m_41619_() || renderInfo.getPosition(i) == null) continue;
            float size = renderInfo.slotHovered == i ? 0.3f : 0.2f;
            this.renderItem(item, stack, renderInfo.getPosition(i), size, null, renderInfo.getHitbox(i), true, tickInfo.light);
        }
        for (i = 27; i <= 31; ++i) {
            ItemStack itemStack = item = i == 31 ? tickInfo.craftingOutput : tickInfo.craftingInput[i - 27];
            if (item.m_41619_() || renderInfo.getPosition(i) == null) continue;
            this.renderItem(item, stack, renderInfo.getPosition(i), 0.2f, null, renderInfo.getHitbox(i), true, tickInfo.light);
        }
        stack.m_85836_();
        Vec3 pos = renderInfo.renderPos;
        Camera cameraInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        stack.m_85837_(-cameraInfo.m_90583_().f_82479_ + pos.f_82479_, -cameraInfo.m_90583_().f_82480_ + pos.f_82480_, -cameraInfo.m_90583_().f_82481_ + pos.f_82481_);
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        stack.m_85837_(0.0, 1.5, 0.0);
        stack.m_85845_(Vector3f.f_122224_.m_122270_(renderInfo.handYaw));
        stack.m_85845_(Vector3f.f_122222_.m_122270_(renderInfo.handPitch));
        stack.m_85845_(Vector3f.f_122227_.m_122270_((float)Math.PI));
        stack.m_85837_(0.0, -1.5, 0.0);
        stack.m_85837_(leftHanded ? -0.5 : 0.5, 0.0, 0.0);
        ImmersiveBackpack.getBackpackModel().m_7695_(stack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110452_((ResourceLocation)BackpackModel.textureLocation)), 0xF000F0, OverlayTexture.f_118083_, renderInfo.rgb.m_122239_(), renderInfo.rgb.m_122260_(), renderInfo.rgb.m_122269_(), 1.0f);
        stack.m_85837_(leftHanded ? -0.75 : 0.75, 0.25, 0.0);
        craftingModel.m_7695_(stack, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110452_((ResourceLocation)BackpackCraftingModel.textureLocation)), 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        if (ActiveConfig.placementGuideMode != PlacementGuideMode.OFF) {
            for (int i2 = 0; i2 < renderInfo.getInputSlots().length; ++i2) {
                if (!this.slotShouldRenderHelpHitbox(tickInfo, i2)) continue;
                AABB itemBox = renderInfo.getInputSlots()[i2];
                this.renderItemGuide(stack, itemBox, 0.2f, this.slotHelpBoxIsSelected(renderInfo, i2), tickInfo.light);
            }
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useBackpack;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(BackpackInfo info, int slotNum) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (slotNum <= 26) {
            return Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(slotNum + 9).m_41619_();
        }
        int tableIndex = slotNum - 27;
        return info.craftingInput[tableIndex] == null || info.craftingInput[tableIndex].m_41619_();
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return true;
    }

    @Override
    public void trackObject(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveBackpack;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return false;
    }

    @Override
    protected void initInfo(BackpackInfo info) {
        Network.INSTANCE.sendToServer((Object)new FetchPlayerStoragePacket("backpack"));
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
    }

    public void processFromNetwork(ImmersiveStorage storage) {
        if (this.getSingleton().infos.size() > 0) {
            BackpackInfo info = (BackpackInfo)this.getSingleton().infos.get(0);
            for (int i = 0; i <= 3; ++i) {
                info.craftingInput[i] = storage.items[i];
            }
            info.craftingOutput = storage.items[4];
        }
    }

    public void doTrack() {
        if (this.infos.isEmpty()) {
            this.infos.add(new BackpackInfo());
        } else {
            this.infos.clear();
        }
    }

    public static Model getBackpackModel() {
        if (ActiveConfig.useLowDetailBackpack) {
            return modelLowDetail;
        }
        return model;
    }

    private void calculatePositions(BackpackInfo info, IVRPlayer vrPlayer) {
        IVRData backpackController = vrPlayer.getController(1);
        info.handPos = backpackController.position();
        info.handPitch = (float)Math.toRadians(backpackController.getPitch());
        info.handYaw = (float)Math.toRadians(backpackController.getYaw());
        info.lookVec = backpackController.getLookAngle();
        info.backVec = info.lookVec.m_82541_().m_82542_(-1.0, -1.0, -1.0);
        info.renderPos = info.handPos.m_82520_(0.0, -0.75, 0.0);
        info.renderPos = info.renderPos.m_82549_(info.backVec.m_82542_(0.16666666666666666, 0.16666666666666666, 0.16666666666666666));
        info.rgb = new Vector3f((float)(ActiveConfig.backpackColor >> 16), (float)(ActiveConfig.backpackColor >> 8 & 0xFF), (float)(ActiveConfig.backpackColor & 0xFF));
        info.rgb.m_122261_(0.003921569f);
        info.centerTopPos = info.handPos.m_82520_(0.0, -0.05, 0.0);
        info.centerTopPos = info.centerTopPos.m_82549_(info.backVec.m_82542_(0.16666666666666666, 0.16666666666666666, 0.16666666666666666));
        Vec3 rightVec = info.lookVec.m_82542_(1.0E16, 0.0, 1.0E16).m_82541_();
        rightVec = VRPlugin.API.isLeftHanded((Player)Minecraft.m_91087_().f_91074_) ? new Vec3(rightVec.f_82481_, 0.0, -rightVec.f_82479_).m_82542_(0.25, 0.0, 0.25) : new Vec3(-rightVec.f_82481_, 0.0, rightVec.f_82479_).m_82542_(0.25, 0.0, 0.25);
        info.centerTopPos = info.centerTopPos.m_82549_(rightVec);
        Vec3 leftVec = rightVec.m_82542_(-1.0, 0.0, -1.0);
        Vector3f downVecF = new Vector3f(0.0f, -1.0f, 0.0f);
        downVecF.m_122251_(Vector3f.f_122222_.m_122270_(info.handPitch));
        downVecF.m_122251_(Vector3f.f_122224_.m_122270_(info.handYaw));
        info.downVec = new Vec3((double)downVecF.m_122239_(), (double)downVecF.m_122260_(), (double)downVecF.m_122269_()).m_82541_();
        Vec3 leftOffset = new Vec3(leftVec.f_82479_ * 0.375, leftVec.f_82480_ * 0.375, leftVec.f_82481_ * 0.375);
        Vec3 rightOffset = new Vec3(rightVec.f_82479_ * 0.375, rightVec.f_82480_ * 0.375, rightVec.f_82481_ * 0.375);
        double tbSpacing = 0.09375;
        Vec3 topOffset = info.lookVec.m_82542_(tbSpacing, tbSpacing, tbSpacing);
        Vec3 botOffset = info.backVec.m_82542_(tbSpacing, tbSpacing, tbSpacing);
        Vec3 pos = info.centerTopPos;
        Vec3[] positions = new Vec3[]{pos.m_82549_(leftOffset).m_82549_(topOffset), pos.m_82549_(topOffset), pos.m_82549_(rightOffset).m_82549_(topOffset), pos.m_82549_(leftOffset), pos, pos.m_82549_(rightOffset), pos.m_82549_(leftOffset).m_82549_(botOffset), pos.m_82549_(botOffset), pos.m_82549_(rightOffset).m_82549_(botOffset)};
        int start = 9 * info.topRow;
        int end = start + 8;
        int midStart = 9 * info.getMidRow();
        int midEnd = midStart + 8;
        Vec3 downOne = info.downVec.m_82542_(0.125, 0.125, 0.125);
        Vec3 downTwo = downOne.m_82542_(2.0, 2.0, 2.0);
        for (int i = 0; i <= 26; ++i) {
            Vec3 posRaw = positions[i % 9];
            Vec3 yDown = this.inRange(i, start, end) ? Vec3.f_82478_ : (this.inRange(i, midStart, midEnd) ? downOne : downTwo);
            Vec3 slotPos = posRaw;
            slotPos = slotPos.m_82549_(yDown);
            info.setPosition(i, slotPos);
            info.setHitbox(i, this.createHitbox(info.getPosition(i), 0.05f));
        }
        Vec3 upVec = info.downVec.m_82542_(-1.0, -1.0, -1.0);
        double upMult = 0.05;
        Vec3 leftCraftingPos = info.centerTopPos.m_82549_(rightVec.m_82542_(1.25, 1.25, 1.25)).m_82549_(upVec.m_82542_(upMult, upMult, upMult));
        Vec3 rightCraftingPos = info.centerTopPos.m_82549_(rightVec.m_82542_(1.75, 1.75, 1.75)).m_82549_(upVec.m_82542_(upMult, upMult, upMult));
        Vec3 centerCraftingPos = info.centerTopPos.m_82549_(rightVec.m_82542_(1.5, 1.5, 1.5)).m_82549_(upVec.m_82542_(upMult, upMult, upMult));
        double craftingOffset = 0.625;
        Vec3[] craftingPositions = new Vec3[]{leftCraftingPos.m_82549_(topOffset.m_82542_(craftingOffset, craftingOffset, craftingOffset)), rightCraftingPos.m_82549_(topOffset.m_82542_(craftingOffset, craftingOffset, craftingOffset)), leftCraftingPos.m_82549_(botOffset.m_82542_(craftingOffset, craftingOffset, craftingOffset)), rightCraftingPos.m_82549_(botOffset.m_82542_(craftingOffset, craftingOffset, craftingOffset))};
        for (int i = 27; i <= 30; ++i) {
            info.setPosition(i, craftingPositions[i - 27]);
            info.setHitbox(i, this.createHitbox(info.getPosition(i), 0.05f));
        }
        info.setPosition(31, centerCraftingPos.m_82549_(upVec.m_82542_(0.125, 0.125, 0.125)));
        info.setHitbox(31, this.createHitbox(info.getPosition(31), 0.05f));
    }

    private BackpackInfo getRenderInfo(BackpackInfo tickInfo) {
        BackpackInfo renderInfo = new BackpackInfo();
        renderInfo.slotHovered = tickInfo.slotHovered;
        renderInfo.topRow = tickInfo.topRow;
        this.calculatePositions(renderInfo, VRPlugin.API.getRenderVRPlayer());
        renderInfo.setInputSlots();
        return renderInfo;
    }
}

