/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.immersive;

import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.immersive.AbstractWorldStorageImmersive;
import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.client.immersive.info.AbstractImmersiveInfo;
import com.hammy275.immersivemc.client.immersive.info.AbstractWorldStorageInfo;
import com.hammy275.immersivemc.client.immersive.info.AnvilInfo;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.immersive.ImmersiveCheckers;
import com.hammy275.immersivemc.common.network.Network;
import com.hammy275.immersivemc.common.network.packet.InteractPacket;
import com.hammy275.immersivemc.common.storage.AnvilStorage;
import com.hammy275.immersivemc.common.storage.ImmersiveStorage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ImmersiveAnvil
extends AbstractWorldStorageImmersive<AnvilInfo> {
    protected final double dist = 0.3333333333333333;

    public ImmersiveAnvil() {
        super(1);
    }

    @Override
    protected void initInfo(AnvilInfo info) {
        this.setHitboxes(info);
    }

    protected void setHitboxes(AnvilInfo info) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        BlockState anvil = Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition());
        info.isReallyAnvil = this.isAnvil(anvil);
        Direction facing = info.isReallyAnvil ? (Direction)anvil.m_61143_((Property)AnvilBlock.f_48764_) : this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_).m_122428_();
        info.renderDirection = facing.m_122427_();
        Vec3i temp = facing.m_122424_().m_122436_();
        Vec3 facingOppositeNormal = new Vec3((double)temp.m_123341_(), (double)temp.m_123342_(), (double)temp.m_123343_());
        temp = facing.m_122436_();
        Vec3 facingNormal = new Vec3((double)temp.m_123341_(), (double)temp.m_123342_(), (double)temp.m_123343_());
        Vec3 middle = this.getTopCenterOfBlock(info.getBlockPosition());
        Vec3 left = middle.m_82549_(facingOppositeNormal.m_82542_(0.3333333333333333, 0.3333333333333333, 0.3333333333333333));
        Vec3 right = middle.m_82549_(facingNormal.m_82542_(0.3333333333333333, 0.3333333333333333, 0.3333333333333333));
        info.setPosition(0, left);
        info.setPosition(1, middle);
        info.setPosition(2, right);
        info.textPos = info.getPosition(1).m_82520_(0.0, 0.5, 0.0);
        float hitboxSize = 0.16260163f;
        info.setHitbox(0, this.createHitbox(left, hitboxSize));
        info.setHitbox(1, this.createHitbox(middle, hitboxSize));
        info.setHitbox(2, this.createHitbox(right, hitboxSize));
        info.lastDir = facing;
    }

    @Override
    protected void doTick(AnvilInfo info, boolean isInVR) {
        Direction facing;
        super.doTick(info, isInVR);
        Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        if (info.isReallyAnvil) {
            BlockState anvil = Minecraft.m_91087_().f_91073_.m_8055_(info.getBlockPosition());
            facing = (Direction)anvil.m_61143_((Property)AnvilBlock.f_48764_);
        } else {
            facing = this.getForwardFromPlayer((Player)Minecraft.m_91087_().f_91074_).m_122428_();
        }
        if (facing != info.lastDir) {
            this.setHitboxes(info);
        }
    }

    @Override
    public BlockPos getLightPos(AnvilInfo info) {
        return info.getBlockPosition().m_7494_();
    }

    @Override
    public boolean shouldRender(AnvilInfo info, boolean isInVR) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        return level != null && level.m_8055_(info.getBlockPosition().m_7494_()).m_60795_() && info.readyToRender();
    }

    @Override
    protected void render(AnvilInfo info, PoseStack stack, boolean isInVR) {
        float itemSize = 0.33333334f / (float)info.getItemTransitionCountdown();
        if (info.isReallyAnvil && info.anvilCost > 0) {
            this.renderText((Component)new TextComponent(I18n.m_118938_((String)"immersivemc.immersive.anvil.levels_needed", (Object[])new Object[]{info.anvilCost})), stack, info.textPos, info.light);
        }
        for (int i = 0; i <= 2; ++i) {
            float renderSize = info.slotHovered == i ? itemSize * 1.25f : itemSize;
            this.renderItem(info.items[i], stack, info.getPosition(i), renderSize, info.renderDirection, Direction.UP, info.getHitbox(i), false, -1, info.light);
        }
    }

    @Override
    public boolean enabledInConfig() {
        return ActiveConfig.useAnvilImmersion;
    }

    @Override
    public void processStorageFromNetwork(AbstractWorldStorageInfo wInfo, ImmersiveStorage storageIn) {
        AnvilInfo info = (AnvilInfo)wInfo;
        info.items = storageIn.items;
        AnvilStorage aStorage = (AnvilStorage)storageIn;
        info.anvilCost = aStorage.xpLevels;
    }

    @Override
    public AnvilInfo getNewInfo(BlockPos pos) {
        return new AnvilInfo(pos, this.getTickTime());
    }

    @Override
    public int getTickTime() {
        return 120;
    }

    @Override
    protected boolean slotShouldRenderHelpHitbox(AnvilInfo info, int slotNum) {
        return info.items[slotNum] == null || info.items[slotNum].m_41619_();
    }

    @Override
    public boolean shouldTrack(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        return ImmersiveCheckers.isAnvil(pos, state, tileEntity, level);
    }

    @Override
    public void trackObject(BlockPos pos, BlockState state, BlockEntity tileEntity, Level level) {
        for (AnvilInfo info : this.getTrackedObjects()) {
            if (!info.getBlockPosition().equals((Object)pos)) continue;
            info.setTicksLeft(120);
            return;
        }
        this.infos.add(new AnvilInfo(pos, 120));
    }

    @Override
    public AbstractImmersive<? extends AbstractImmersiveInfo> getSingleton() {
        return Immersives.immersiveAnvil;
    }

    @Override
    public boolean shouldBlockClickIfEnabled(AbstractImmersiveInfo info) {
        return true;
    }

    @Override
    public void handleRightClick(AbstractImmersiveInfo info, Player player, int closest, InteractionHand hand) {
        Network.INSTANCE.sendToServer((Object)new InteractPacket(info.getBlockPosition(), closest, hand));
    }

    protected boolean isAnvil(BlockState state) {
        return state.m_60734_() instanceof AnvilBlock;
    }
}

