/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client.config.screen;

import com.hammy275.immersivemc.client.config.screen.ScreenUtils;
import com.hammy275.immersivemc.client.immersive.AbstractImmersive;
import com.hammy275.immersivemc.client.model.Cube1x1;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.ImmersiveMCConfig;
import com.hammy275.immersivemc.common.config.PlacementGuideMode;
import com.hammy275.immersivemc.common.util.RGBA;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.time.Instant;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemGuideCustomizeScreen
extends Screen {
    private final AABB renderHitbox = AABB.m_165882_((Vec3)Vec3.f_82478_, (double)128.0, (double)128.0, (double)128.0);
    private static final String[] types = new String[]{"item_guide", "item_guide_selected", "ranged_grab"};
    private static final char[] rgba = new char[]{'r', 'g', 'b', 'a'};
    private final Screen lastScreen;
    protected OptionsList list;
    protected static int BUTTON_WIDTH = 128;
    protected static int BUTTON_HEIGHT = 20;

    public ItemGuideCustomizeScreen(Screen lastScreen) {
        super((Component)new TranslatableComponent("screen.immersivemc.item_guide_customize_screen"));
        this.lastScreen = lastScreen;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float f) {
        RGBA color;
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, f);
        ItemGuideCustomizeScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2), (int)8, (int)0xFFFFFF);
        this.renderPreview(stack, ActiveConfig.itemGuideColor, 0.25f, false);
        this.renderPreview(stack, ActiveConfig.itemGuideSelectedColor, 0.5f, false);
        this.renderPreview(stack, ActiveConfig.rangedGrabColor, 0.75f, true);
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.f_96543_ * 7 / 8 - 16, this.f_96544_ * 1 / 4 - 16, this.f_96543_ * 7 / 8 + 16, this.f_96544_ * 1 / 4 + 16)) {
            this.m_96617_(stack, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)new TranslatableComponent("config.immersivemc.item_guide.desc"), 170), mouseX, mouseY);
        }
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.f_96543_ * 7 / 8 - 16, this.f_96544_ * 1 / 2 - 16, this.f_96543_ * 7 / 8 + 16, this.f_96544_ * 1 / 2 + 16)) {
            this.m_96617_(stack, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)new TranslatableComponent("config.immersivemc.item_guide_selected.desc"), 170), mouseX, mouseY);
        }
        if (ScreenUtils.mouseInBox(mouseX, mouseY, this.f_96543_ * 7 / 8 - 16, this.f_96544_ * 3 / 4 - 16 + (int)(16.0f * (color = ActiveConfig.rangedGrabColor).alphaF()), this.f_96543_ * 7 / 8 + 16, this.f_96544_ * 3 / 4 + 16 + (int)(16.0f * color.alphaF()))) {
            this.m_96617_(stack, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)new TranslatableComponent("config.immersivemc.ranged_grab_color.desc"), 170), mouseX, mouseY);
        }
    }

    private void renderPreview(PoseStack stack, RGBA color, float heightMult, boolean renderSquare) {
        stack.m_85836_();
        stack.m_85837_((double)this.f_96543_ * 0.875, (double)((float)this.f_96544_ * heightMult), 0.0);
        stack.m_85841_(0.25f, 0.25f, 0.25f);
        if (!renderSquare) {
            long currentTimeMilli = Instant.now().toEpochMilli();
            long millisPerRot = 8000L;
            float rot = (float)(currentTimeMilli % millisPerRot) / (float)millisPerRot * ((float)Math.PI * 2);
            stack.m_85845_(Vector3f.f_122224_.m_122270_(rot));
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        if (ActiveConfig.placementGuideMode == PlacementGuideMode.CUBE || renderSquare) {
            stack.m_85837_(0.0, 64.0, 0.0);
            if (renderSquare) {
                stack.m_85837_(0.0, (double)(64.0f * color.alphaF()), 0.0);
                stack.m_85841_(color.alphaF(), color.alphaF(), color.alphaF());
            }
            float alpha = renderSquare ? 1.0f : color.alphaF();
            AbstractImmersive.cubeModel.render(stack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)Cube1x1.textureLocation)), color.redF(), color.greenF(), color.blueF(), alpha, 64.0f, AbstractImmersive.maxLight);
        } else if (ActiveConfig.placementGuideMode == PlacementGuideMode.OUTLINE) {
            LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)this.renderHitbox, (float)color.redF(), (float)color.greenF(), (float)color.blueF(), (float)color.alphaF());
        }
        buffer.m_109911_();
        stack.m_85849_();
    }

    protected void m_7856_() {
        this.list = new OptionsList(Minecraft.m_91087_(), this.f_96543_ * 3 / 4, this.f_96544_, 32, this.f_96544_ - 32, 24);
        this.list.m_94471_((Option)CycleOption.m_167747_((String)"config.immersivemc.placement_guide_mode", () -> IntStream.rangeClosed(0, PlacementGuideMode.values().length - 1).boxed().collect(Collectors.toList()), optionIndex -> new TranslatableComponent("config.immersivemc.placement_guide_mode." + optionIndex), ignored -> (Integer)ImmersiveMCConfig.placementGuideMode.get(), (ignored, ignored2, newIndex) -> {
            ImmersiveMCConfig.placementGuideMode.set(newIndex);
            ImmersiveMCConfig.placementGuideMode.save();
            ActiveConfig.loadConfigFromFile();
        }).m_167773_(minecraft -> optionIndex -> minecraft.f_91062_.m_92923_((FormattedText)new TranslatableComponent("config.immersivemc.placement_guide_mode.desc"), 200)));
        for (int i = 0; i < types.length; ++i) {
            RGBA color = i == 0 ? ActiveConfig.itemGuideColor : (i == 1 ? ActiveConfig.itemGuideSelectedColor : ActiveConfig.rangedGrabColor);
            for (char c : rgba) {
                String key = types[i];
                String compKey = "config.immersivemc." + key + "_" + c;
                this.list.m_94471_((Option)ScreenUtils.createIntSlider(compKey, value -> new TextComponent(I18n.m_118938_((String)compKey, (Object[])new Object[0]) + ": " + value), 0, 255, () -> color.getColor(c), newVal -> color.setColor(c, (int)newVal)));
            }
        }
        this.m_142416_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)new Button((this.f_96543_ - BUTTON_WIDTH) / 2, this.f_96544_ - 26, BUTTON_WIDTH, BUTTON_HEIGHT, (Component)new TranslatableComponent("gui.done"), button -> this.m_7379_()));
    }

    public void m_7379_() {
        ImmersiveMCConfig.itemGuideColor.set((Object)ActiveConfig.itemGuideColor.toLong());
        ImmersiveMCConfig.itemGuideSelectedColor.set((Object)ActiveConfig.itemGuideSelectedColor.toLong());
        ImmersiveMCConfig.rangedGrabColor.set((Object)ActiveConfig.rangedGrabColor.toLong());
        Minecraft.m_91087_().m_91152_(this.lastScreen);
        ActiveConfig.loadConfigFromFile();
    }
}

