/*
 * Decompiled with CFR 0.152.
 */
package com.hammy275.immersivemc.client;

import com.hammy275.immersivemc.client.immersive.Immersives;
import com.hammy275.immersivemc.common.config.ActiveConfig;
import com.hammy275.immersivemc.common.config.CommonConstants;
import com.hammy275.immersivemc.common.config.PlacementMode;
import com.hammy275.immersivemc.common.vr.VRPlugin;
import com.hammy275.immersivemc.common.vr.VRPluginVerify;
import com.hammy275.immersivemc.mixin.MinecraftMixinAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ClientUtil {
    public static int immersiveLeftClickCooldown = 0;

    public static Tuple<Vec3, Vec3> getStartAndEndOfLookTrace(Player player) {
        Vec3 end;
        Vec3 start;
        double dist = Minecraft.m_91087_().f_91072_.m_105286_();
        if (VRPluginVerify.clientInVR()) {
            start = VRPlugin.API.getVRPlayer(player).getController0().position();
            Vec3 viewVec = VRPlugin.API.getVRPlayer(player).getController0().getLookAngle();
            end = start.m_82520_(viewVec.f_82479_ * dist, viewVec.f_82480_ * dist, viewVec.f_82481_ * dist);
        } else {
            start = player.m_20299_(1.0f);
            Vec3 viewVec = player.m_20252_(1.0f);
            end = player.m_20299_(1.0f).m_82520_(viewVec.f_82479_ * dist, viewVec.f_82480_ * dist, viewVec.f_82481_ * dist);
        }
        return new Tuple((Object)start, (Object)end);
    }

    public static void setRightClickCooldown(int amount) {
        ((MinecraftMixinAccessor)Minecraft.m_91087_()).setRightClickDelay(amount);
    }

    public static PlacementMode getPlacementModeIndirect() {
        return ClientUtil.getPlacementModeIndirect(false);
    }

    public static PlacementMode getPlacementModeIndirect(boolean leftClickAlreadyDoesSomething) {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_() && !leftClickAlreadyDoesSomething ? PlacementMode.PLACE_ALL : ActiveConfig.placementMode;
    }

    public static Direction getClosestDirection(Vec3 velocity) {
        double max = Math.max(Math.abs(velocity.f_82479_), Math.max(Math.abs(velocity.f_82480_), Math.abs(velocity.f_82481_)));
        if (max == Math.abs(velocity.f_82479_)) {
            return velocity.f_82479_ < 0.0 ? Direction.WEST : Direction.EAST;
        }
        if (max == Math.abs(velocity.f_82480_)) {
            return velocity.f_82480_ < 0.0 ? Direction.DOWN : Direction.UP;
        }
        return velocity.f_82481_ < 0.0 ? Direction.NORTH : Direction.SOUTH;
    }

    public static void openBag(Player player) {
        if (VRPluginVerify.hasAPI) {
            if (VRPlugin.API.playerInVR(player)) {
                if (VRPlugin.API.apiActive(player)) {
                    Immersives.immersiveBackpack.doTrack();
                } else {
                    player.m_6352_((Component)new TranslatableComponent("message.immersivemc.no_api_server"), player.m_142081_());
                }
            } else {
                player.m_6352_((Component)new TranslatableComponent("message.immersivemc.not_in_vr"), player.m_142081_());
            }
        } else {
            player.m_6352_((Component)new TranslatableComponent("message.immersivemc.no_api", new Object[]{CommonConstants.vrAPIVersionAsString(), CommonConstants.firstNonCompatibleFutureVersionAsString()}), player.m_142081_());
        }
    }
}

