/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration. The feature even fixes the Wither health bar not updating on spawn.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maximumBonusRegenConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusRegenConfig;
    private final ForgeConfigSpec.DoubleValue bonusRegenRatioWhenHitConfig;
    public double bonusHealth = 720.0;
    public double maxBonusRegen = 2.0;
    public double bonusRegen = 2.4;
    public double bonusRegenRatioWhenHit = 0.6;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusHealthConfig = Config.builder.comment("Increase Wither's Health by this value at max difficulty (scales accordingly at lower difficulties)").defineInRange("Health Bonus per Difficulty", this.bonusHealth, 0.0, Double.MAX_VALUE);
        this.maximumBonusRegenConfig = Config.builder.comment("Maximum bonus regeneration per second given by \"Bonus Regeneration\".\nSet to 0 to disable bonus health regeneration. This doesn't affect the natural regeneration of the Wither (1 Health per Second).\nNote that this bonus health regen is disabled when Wither's health is between 49% and 50% to prevent making it impossible to approach when reaches half health.").defineInRange("Maximum Bonus Regeneration", this.maxBonusRegen, 0.0, Double.MAX_VALUE);
        this.bonusRegenConfig = Config.builder.comment("How many half hearts will the Wither regen at max difficulty. This is added to the natural regeneration of the Wither (1 Health per Second).").defineInRange("Bonus Regeneration", this.bonusRegen, 0.0, Double.MAX_VALUE);
        this.bonusRegenRatioWhenHitConfig = Config.builder.comment("Bonus regeneration will be multiplied by this ratio when the Wither has been hit in the last 3 seconds.").defineInRange("Bonus Regeneration Ratio When Hit", this.bonusRegenRatioWhenHit, 0.0, 2.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusHealth = (Double)this.bonusHealthConfig.get();
        this.maxBonusRegen = (Double)this.maximumBonusRegenConfig.get();
        this.bonusRegen = (Double)this.bonusRegenConfig.get();
        this.bonusRegenRatioWhenHit = (Double)this.bonusRegenRatioWhenHitConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        WitherBoss wither;
        Entity entity;
        if (event.getWorld().f_46443_ || !this.isEnabled() || this.bonusHealth == 0.0 || !((entity = event.getEntity()) instanceof WitherBoss) || (wither = (WitherBoss)entity).m_21051_(Attributes.f_22276_).m_22111_(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)wither, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(this.bonusHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither)), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        WitherBoss wither;
        block7: {
            block6: {
                Entity entity;
                if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof WitherBoss)) break block6;
                wither = (WitherBoss)entity;
                if (this.bonusRegen != 0.0 && this.maxBonusRegen != 0.0 && wither.m_31502_() <= 0 && wither.m_6084_()) break block7;
            }
            return;
        }
        if (wither.m_21223_() / wither.m_21233_() > 0.49f && wither.m_21223_() / wither.m_21233_() < 0.5f) {
            return;
        }
        float heal = (float)Math.min(this.bonusRegen * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither), this.maxBonusRegen);
        heal /= 20.0f;
        if (wither.f_19797_ - wither.m_21213_() <= 60) {
            heal = (float)((double)heal * this.bonusRegenRatioWhenHit);
        }
        if (heal > 0.0f) {
            wither.m_5634_(heal);
        }
    }
}

