/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import com.google.common.util.concurrent.AtomicDouble;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.capability.Difficulty;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Label(name="Difficulty Settings", description="How difficulty is handled for the Wither.")
public class DifficultyFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Integer> spawnRadiusPlayerCheckConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> sumSpawnedWitherDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusDifficultyPerPlayerConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> startingDifficultyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> showFirstSummonedWitherMessageConfig;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlacklistConfig;
    private static final List<String> defaultEntityBlacklist = List.of("botania:pink_wither");
    public int spawnRadiusPlayerCheck = 128;
    public boolean sumSpawnedWitherDifficulty = false;
    public double bonusDifficultyPerPlayer = 0.25;
    public int maxDifficulty = 8;
    public int startingDifficulty = 0;
    public boolean showFirstSummonedWitherMessage = true;
    public List<String> entityBlacklist = defaultEntityBlacklist;

    public DifficultyFeature(Module module) {
        super(Config.builder, module, true, false);
        this.pushConfig(Config.builder);
        this.spawnRadiusPlayerCheckConfig = Config.builder.comment("How much blocks from wither will be scanned for players to check for difficulty").defineInRange("Spawn Radius Player Check", this.spawnRadiusPlayerCheck, 16, Integer.MAX_VALUE);
        this.sumSpawnedWitherDifficultyConfig = Config.builder.comment("If false and there's more than 1 player around the Wither, difficulty will be the average of all the players' difficulty instead of summing them.").define("Sum Spawned Wither Difficulty", this.sumSpawnedWitherDifficulty);
        this.bonusDifficultyPerPlayerConfig = Config.builder.comment("Percentage bonus difficulty added to the Wither when more than one player is present. Each player past the first one will add this percentage to the difficulty.").defineInRange("Bonus Difficulty per Player", this.bonusDifficultyPerPlayer, 0.0, Double.MAX_VALUE);
        this.maxDifficultyConfig = Config.builder.comment("The Maximum difficulty (times spawned) reachable by Wither.").defineInRange("Max Difficulty", this.maxDifficulty, 1, Integer.MAX_VALUE);
        this.startingDifficultyConfig = Config.builder.comment("How much difficulty will players start with when joining a world? Note that this will apply when the first Wither is spawned so if the player has already spawned one this will not apply.").defineInRange("Starting Difficulty", this.startingDifficulty, 0, Integer.MAX_VALUE);
        this.showFirstSummonedWitherMessageConfig = Config.builder.comment("Set to false to disable the first Wither summoned message.").define("Show First Summoned Wither Message", this.showFirstSummonedWitherMessage);
        this.entityBlacklistConfig = Config.builder.comment("Entities that extend the vanilla Wither but shouldn't be taken into account by the mod (e.g. Botania's Pink Wither).").defineList("Entity Blacklist", this.entityBlacklist, o -> o instanceof String);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.spawnRadiusPlayerCheck = (Integer)this.spawnRadiusPlayerCheckConfig.get();
        this.sumSpawnedWitherDifficulty = (Boolean)this.sumSpawnedWitherDifficultyConfig.get();
        this.bonusDifficultyPerPlayer = (Double)this.bonusDifficultyPerPlayerConfig.get();
        this.maxDifficulty = (Integer)this.maxDifficultyConfig.get();
        this.startingDifficulty = (Integer)this.startingDifficultyConfig.get();
        this.showFirstSummonedWitherMessage = (Boolean)this.showFirstSummonedWitherMessageConfig.get();
        this.entityBlacklist = new ArrayList<String>();
        for (String string : (List)this.entityBlacklistConfig.get()) {
            if (!ForgeRegistries.ENTITIES.containsKey(new ResourceLocation(string))) {
                LogHelper.warn("Entity %s for Wither's Difficulty Feature entityBlacklist doesn't exist, will be ignored.", string);
            }
            this.entityBlacklist.add(string);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)entity;
        if (this.entityBlacklist.contains(event.getEntity().m_6095_().getRegistryName().toString())) {
            return;
        }
        CompoundTag witherTags = wither.getPersistentData();
        if (witherTags.m_128441_("progressivebosses:difficulty")) {
            return;
        }
        BlockPos pos1 = wither.m_142538_().m_142082_(-this.spawnRadiusPlayerCheck, -this.spawnRadiusPlayerCheck, -this.spawnRadiusPlayerCheck);
        BlockPos pos2 = wither.m_142538_().m_142082_(this.spawnRadiusPlayerCheck, this.spawnRadiusPlayerCheck, this.spawnRadiusPlayerCheck);
        AABB bb = new AABB(pos1, pos2);
        List players = event.getWorld().m_45976_(ServerPlayer.class, bb);
        if (players.size() == 0) {
            return;
        }
        AtomicDouble witherDifficulty = new AtomicDouble(0.0);
        for (ServerPlayer player : players) {
            player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
                witherDifficulty.addAndGet((double)difficulty.getSpawnedWithers());
                if (difficulty.getSpawnedWithers() >= this.maxDifficulty) {
                    return;
                }
                if (difficulty.getSpawnedWithers() <= this.startingDifficulty && this.showFirstSummonedWitherMessage) {
                    player.m_6352_((Component)new TranslatableComponent("wither.first_summon"), Util.f_137441_);
                }
                difficulty.addSpawnedWithers(1);
            });
        }
        if (!this.sumSpawnedWitherDifficulty) {
            witherDifficulty.set(witherDifficulty.get() / (double)players.size());
        }
        if (players.size() > 1) {
            witherDifficulty.set(witherDifficulty.get() * (1.0 + (double)(players.size() - 1) * this.bonusDifficultyPerPlayer));
        }
        witherTags.m_128350_("progressivebosses:difficulty", (float)witherDifficulty.get());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void setPlayerData(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.getCapability(Difficulty.INSTANCE).ifPresent(difficulty -> {
            if (difficulty.getSpawnedWithers() < this.startingDifficulty) {
                difficulty.setSpawnedWithers(this.startingDifficulty);
                LogHelper.info("[Progressive Bosses] %s spawned withers counter was below the set 'Starting Difficulty', Has been increased to match 'Starting Difficulty'", player.m_7755_().getString());
            }
        });
    }
}

