/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.progressivebosses.setup.Config;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances", description="Handles the Damage Resistances")
public class ResistancesFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> resistancePerElderGuardianDefeatedConfig;
    public double resistancePerElderGuardianDefeated = 0.3;

    public ResistancesFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.resistancePerElderGuardianDefeatedConfig = Config.builder.comment("Percentage Damage Reduction for each Elder Guardian Defeated.").defineInRange("Damage Reduction per Elder Guardian Defeated", this.resistancePerElderGuardianDefeated, 0.0, 1.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.resistancePerElderGuardianDefeated = (Double)this.resistancePerElderGuardianDefeatedConfig.get();
    }

    @SubscribeEvent
    public void onElderGuardianDamage(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.resistancePerElderGuardianDefeated == 0.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        float damageReduction = (float)(this.resistancePerElderGuardianDefeated * (double)elderGuardian.getPersistentData().m_128451_("progressivebosses:difficulty"));
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }
}

