/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Health regeneration.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> absorptionHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> healthRegenConfig;
    public double bonusHealth = 0.5;
    public double absorptionHealth = 40.0;
    public double healthRegen = 0.5;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusHealthConfig = Config.builder.comment("Increase Elder Guardians' Health by this percentage (1 = +100% health)").defineInRange("Health Bonus per Difficulty", this.bonusHealth, 0.0, Double.MAX_VALUE);
        this.absorptionHealthConfig = Config.builder.comment("Adds absorption health to Elder Guradians (health that doesn't regen)").defineInRange("Absorption Health", this.absorptionHealth, 0.0, Double.MAX_VALUE);
        this.healthRegenConfig = Config.builder.comment("Health Regen per second").defineInRange("Health Regen", this.healthRegen, 0.0, Double.MAX_VALUE);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusHealth = (Double)this.bonusHealthConfig.get();
        this.absorptionHealth = (Double)this.absorptionHealthConfig.get();
        this.healthRegen = (Double)this.healthRegenConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.bonusHealth == 0.0 && this.absorptionHealth == 0.0) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        CompoundTag nbt = elderGuardian.getPersistentData();
        if (nbt.m_128441_("progressivebosses:difficulty")) {
            return;
        }
        if (this.bonusHealth > 0.0) {
            if (elderGuardian.m_21051_(Attributes.f_22276_).m_22111_(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
                return;
            }
            MCUtils.applyModifier((LivingEntity)elderGuardian, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)this.bonusHealth, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (this.absorptionHealth > 0.0) {
            elderGuardian.m_7911_((float)this.absorptionHealth);
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        if (this.healthRegen == 0.0) {
            return;
        }
        if (!elderGuardian.m_6084_()) {
            return;
        }
        float heal = (float)this.healthRegen / 20.0f;
        elderGuardian.m_5634_(heal);
    }
}

