/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.setup.Config;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration.")
public class HealthFeature
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> bonusHealthConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusRegenConfig;
    private final ForgeConfigSpec.ConfigValue<Double> maximumBonusRegenConfig;
    private final ForgeConfigSpec.ConfigValue<Double> bonusCrystalRegenConfig;
    private final ForgeConfigSpec.DoubleValue bonusRegenRatioWhenHitConfig;
    public double bonusHealth = 200.0;
    public double bonusRegen = 1.0;
    public double maxBonusRegen = 1.0;
    public double bonusCrystalRegen = 0.0;
    public double bonusRegenRatioWhenHit = 0.4;

    public HealthFeature(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.bonusHealthConfig = Config.builder.comment("Ender Dragon health will be increased by this value at max difficulty (scaling accordingly at lower difficulties)").defineInRange("Health Bonus at Max Difficulty", this.bonusHealth, 0.0, Double.MAX_VALUE);
        this.bonusRegenConfig = Config.builder.comment("How much health will the Ender Dragon regen at max difficulty (scaling accordingly at lower difficulties). This doesn't affect the health regen given by crystals.").defineInRange("Bonus Regeneration", this.bonusRegen, 0.0, Double.MAX_VALUE);
        this.maximumBonusRegenConfig = Config.builder.comment("Maximum bonus regeneration per second given by \"Bonus Regeneration\". Set to 0 to disable bonus health regeneration. Can be lower than \"Bonus Regeneration\". This doesn't affect the health regen given by crystals.").defineInRange("Maximum Bonus Regeneration", this.maxBonusRegen, 0.0, Double.MAX_VALUE);
        this.bonusCrystalRegenConfig = Config.builder.comment("How much health (when missing 100% health) will the Ender Dragon regen at max difficulty each second whenever she's attached to a Crystal. So if she's missing 30% health, this will be 30% effective. This is added to the normal Crystal regen.").defineInRange("Bonus Crystal Regeneration", this.bonusCrystalRegen, 0.0, Double.MAX_VALUE);
        this.bonusRegenRatioWhenHitConfig = Config.builder.comment("Bonus regeneration (also crystal bonus regeneration) will be multiplied by this ratio when the Dragon has been hit in the last 3 seconds.").defineInRange("Bonus Regeneration Ratio When Hit", this.bonusRegenRatioWhenHit, 0.0, 2.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.bonusHealth = (Double)this.bonusHealthConfig.get();
        this.maxBonusRegen = (Double)this.maximumBonusRegenConfig.get();
        this.bonusRegen = (Double)this.bonusRegenConfig.get();
        this.bonusCrystalRegen = (Double)this.bonusCrystalRegenConfig.get();
        this.bonusRegenRatioWhenHit = (Double)this.bonusRegenRatioWhenHitConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        EnderDragon dragon;
        Entity entity;
        if (event.getWorld().f_46443_ || !this.isEnabled() || this.bonusHealth == 0.0 || !((entity = event.getEntity()) instanceof EnderDragon) || (dragon = (EnderDragon)entity).m_21051_(Attributes.f_22276_).m_22111_(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)dragon, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(this.bonusHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon)), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        float crystalBonusHeal;
        EnderDragon dragon;
        Entity entity;
        if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !((entity = event.getEntity()) instanceof EnderDragon) || !(dragon = (EnderDragon)entity).m_6084_() || dragon.m_31157_().m_31415_().m_7309_() == EnderDragonPhase.f_31386_) {
            return;
        }
        CompoundTag tags = dragon.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float flatBonusHeal = (float)Math.min(this.bonusRegen * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon), this.maxBonusRegen);
        float heal = flatBonusHeal + (crystalBonusHeal = this.getCrystalBonusHeal(dragon));
        if (heal == 0.0f) {
            return;
        }
        heal /= 20.0f;
        if (dragon.f_19797_ - dragon.m_21213_() <= 60) {
            heal = (float)((double)heal * this.bonusRegenRatioWhenHit);
        }
        dragon.m_5634_(heal);
    }

    private float getCrystalBonusHeal(EnderDragon dragon) {
        if (this.bonusCrystalRegen == 0.0 || dragon.f_31086_ == null || !dragon.f_31086_.m_6084_()) {
            return 0.0f;
        }
        double currHealthPerc = 1.0f - dragon.m_21223_() / dragon.m_21233_();
        return (float)(this.bonusCrystalRegen * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon) * currHealthPerc);
    }
}

