/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.stream.LongStream;
import net.minecraft.world.level.ChunkPos;

public class ChunkTracker {
    private final Long2IntOpenHashMap single = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap merged = new Long2IntOpenHashMap();
    private final LongLinkedOpenHashSet dirty = new LongLinkedOpenHashSet();

    public ChunkTracker() {
        this.single.defaultReturnValue(0);
        this.merged.defaultReturnValue(0);
    }

    public void update() {
        if (this.dirty.isEmpty()) {
            return;
        }
        LongSet dirty = this.markDirtyChunks();
        this.recalculateChunks(dirty);
        this.dirty.clear();
    }

    private void recalculateChunks(LongSet set) {
        LongIterator it = set.iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int x = ChunkPos.m_45592_((long)key);
            int z = ChunkPos.m_45602_((long)key);
            int flags = this.single.get(key);
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oz = -1; oz <= 1; ++oz) {
                    flags &= this.single.get(ChunkPos.m_45589_((int)(ox + x), (int)(oz + z)));
                }
            }
            if (flags != 0) {
                this.merged.put(key, flags);
                continue;
            }
            this.merged.remove(key);
        }
    }

    private LongSet markDirtyChunks() {
        LongOpenHashSet dirty = new LongOpenHashSet((LongCollection)this.dirty);
        LongListIterator it = this.dirty.iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int x = ChunkPos.m_45592_((long)key);
            int z = ChunkPos.m_45602_((long)key);
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oz = -1; oz <= 1; ++oz) {
                    dirty.add(ChunkPos.m_45589_((int)(ox + x), (int)(oz + z)));
                }
            }
        }
        return dirty;
    }

    public boolean loadChunk(int x, int z) {
        int flags;
        long key = ChunkPos.m_45589_((int)x, (int)z);
        if (this.single.put(key, flags = this.single.get(key) | 1) == flags) {
            return false;
        }
        this.dirty.add(key);
        return true;
    }

    public void onLightDataAdded(int x, int z) {
        long key = ChunkPos.m_45589_((int)x, (int)z);
        int existingFlags = this.single.get(key);
        if ((existingFlags & 1) == 0) {
            return;
        }
        this.single.put(key, existingFlags | 2);
        this.dirty.add(key);
    }

    public boolean unloadChunk(int x, int z) {
        long key = ChunkPos.m_45589_((int)x, (int)z);
        if (this.single.remove(key) == 0) {
            return false;
        }
        this.dirty.add(key);
        return true;
    }

    public boolean hasMergedFlags(int x, int z, int flags) {
        return (this.merged.get(ChunkPos.m_45589_((int)x, (int)z)) & flags) == flags;
    }

    public LongStream getChunks(int flags) {
        return this.single.long2IntEntrySet().stream().filter(entry -> (entry.getIntValue() & flags) == flags).mapToLong(Long2IntMap.Entry::getLongKey);
    }
}

