/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import java.util.Objects;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;

public class SodiumPreLaunch {
    private static final Logger LOGGER = LogManager.getLogger((String)"Rubidium");

    public static void onPreLaunch() {
        DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> SodiumPreLaunch::checkJemalloc);
    }

    private static Object checkJemalloc() {
        if (Platform.get() == Platform.WINDOWS && SodiumPreLaunch.isVersionWithinRange("5.2.0-0-gb0b3e49a54ec29e32636f4577d9d5a896d67fd20", "5.0.0", "5.2.0")) {
            LOGGER.info("Trying to switch memory allocators to work around memory leaks present with Jemalloc 5.0.0 through 5.2.0 on Windows");
            if (!Objects.equals(Configuration.MEMORY_ALLOCATOR.get(), "system")) {
                Configuration.MEMORY_ALLOCATOR.set((Object)"system");
            }
        }
        return null;
    }

    private static boolean isVersionWithinRange(String curStr, String minStr, String maxStr) {
        SemanticVersion max;
        SemanticVersion min;
        SemanticVersion cur;
        try {
            cur = SemanticVersion.parse(curStr);
            min = SemanticVersion.parse(minStr);
            max = SemanticVersion.parse(maxStr);
        }
        catch (VersionParsingException e) {
            LOGGER.warn("Unable to parse version string", (Throwable)e);
            return false;
        }
        return cur.compareTo(min) >= 0 && cur.compareTo(max) <= 0;
    }
}

