/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.recipe;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.smileycorp.atlas.api.recipe.WeightedOutputs;

public class FixedOutputs<T>
extends WeightedOutputs<T> {
    public FixedOutputs(Collection<T> entries) {
        this(1, entries);
    }

    public FixedOutputs(int defaultTries, Collection<T> entries) {
        super(defaultTries, FixedOutputs.mapCollection(entries));
    }

    @Override
    public void addEntry(T t, int weight) {
        this.addEntry(t);
    }

    public void addEntry(T t) {
        this.entries.add(new AbstractMap.SimpleEntry<T, Integer>(t, 1));
    }

    @Override
    public void addEntries(Collection<Map.Entry<T, Integer>> entries) {
        this.entries.addAll(FixedOutputs.mapEntries(entries));
    }

    public void addCollection(Collection<T> entries) {
        this.entries.addAll(FixedOutputs.mapCollection(entries));
    }

    @Override
    public void addEntries(Map<T, Integer> entries) {
        this.entries.addAll(FixedOutputs.mapCollection(entries.keySet()));
    }

    @Override
    public List<T> getResults(Random rand, int tries) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < tries * this.defaultTries; ++i) {
            this.getResult(list, i);
        }
        return list;
    }

    private void getResult(List<T> list, int i) {
        if (i < this.entries.size()) {
            list.add(((Map.Entry)this.entries.get(i)).getKey());
        } else {
            this.getResult(list, i - this.entries.size());
        }
    }

    private static <T> List<Map.Entry<T, Integer>> mapCollection(Collection<T> entries) {
        ArrayList<Map.Entry<T, Integer>> result = new ArrayList<Map.Entry<T, Integer>>();
        for (T entry : entries) {
            result.add(new AbstractMap.SimpleEntry<T, Integer>(entry, 1));
        }
        return result;
    }

    private static <T> List<Map.Entry<T, Integer>> mapEntries(Collection<Map.Entry<T, Integer>> entries) {
        ArrayList<Map.Entry<T, Integer>> result = new ArrayList<Map.Entry<T, Integer>>();
        for (Map.Entry<T, Integer> entry : entries) {
            result.add(new AbstractMap.SimpleEntry<T, Integer>(entry.getKey(), 1));
        }
        return result;
    }
}

