/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class PlayerTextureRenderer {
    private static final Map<UUID, GameProfile> PROFILES = Maps.newHashMap();

    public static ResourceLocation getTexture(Optional<UUID> optional, MinecraftProfileTexture.Type type) {
        GameProfile profile;
        if (optional.isEmpty()) {
            switch (type) {
                case SKIN: {
                    return DefaultPlayerSkin.m_118626_();
                }
                case ELYTRA: {
                    return new ResourceLocation("textures/entity/elytra.png");
                }
            }
            return null;
        }
        UUID uuid = optional.get();
        PlayerInfo playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(uuid);
        if (playerinfo != null) {
            switch (type) {
                case SKIN: {
                    return playerinfo.m_105337_();
                }
                case CAPE: {
                    return playerinfo.m_105338_();
                }
                case ELYTRA: {
                    ResourceLocation loc = playerinfo.m_105339_();
                    return loc == null ? playerinfo.m_105338_() : loc;
                }
            }
        }
        Minecraft mc = Minecraft.m_91087_();
        if (PROFILES.containsKey(uuid)) {
            profile = PROFILES.get(uuid);
        } else {
            profile = new GameProfile(uuid, null);
            mc.m_91108_().fillProfileProperties(profile, true);
            PROFILES.put(uuid, profile);
        }
        SkinManager manager = mc.m_91109_();
        Map textures = manager.m_118815_(profile);
        if (textures.containsKey(type)) {
            return manager.m_118825_((MinecraftProfileTexture)textures.get(type), type);
        }
        if (type == MinecraftProfileTexture.Type.ELYTRA && textures.containsKey(MinecraftProfileTexture.Type.CAPE)) {
            return manager.m_118825_((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.CAPE), MinecraftProfileTexture.Type.CAPE);
        }
        switch (type) {
            case SKIN: {
                return DefaultPlayerSkin.m_118627_((UUID)Player.m_36198_((GameProfile)profile));
            }
            case ELYTRA: {
                return new ResourceLocation("textures/entity/elytra.png");
            }
        }
        return null;
    }

    public static ResourceLocation getTexture(String username, MinecraftProfileTexture.Type type) {
        return PlayerTextureRenderer.getTexture(PlayerTextureRenderer.getUUID(username), type);
    }

    public static String getSkinType(Optional<UUID> optional) {
        GameProfile profile;
        if (optional.isEmpty()) {
            return "default";
        }
        UUID uuid = optional.get();
        PlayerInfo playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(uuid);
        if (playerinfo != null) {
            return playerinfo.m_105336_();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (PROFILES.containsKey(uuid)) {
            profile = PROFILES.get(uuid);
        } else {
            profile = new GameProfile(uuid, null);
            mc.m_91108_().fillProfileProperties(profile, true);
            PROFILES.put(uuid, profile);
        }
        SkinManager manager = mc.m_91109_();
        Map textures = manager.m_118815_(profile);
        if (textures.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return ((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN)).getMetadata("model");
        }
        return DefaultPlayerSkin.m_118629_((UUID)Player.m_36198_((GameProfile)profile));
    }

    public static String getSkinType(String username) {
        return PlayerTextureRenderer.getSkinType(PlayerTextureRenderer.getUUID(username));
    }

    public static Optional<UUID> getUUID(String username) {
        Optional<UUID> optional;
        block9: {
            for (Map.Entry<UUID, GameProfile> entry : PROFILES.entrySet()) {
                if (!entry.getValue().getName().equals(username)) continue;
                return Optional.of(entry.getKey());
            }
            CloseableHttpClient client = HttpClients.createDefault();
            try {
                URI uri = new URI("https://api.mojang.com/users/profiles/minecraft/" + username);
                String message = EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)new HttpGet(uri)).getEntity());
                JsonObject json = (JsonObject)JsonParser.parseString((String)message);
                optional = Optional.of(UUID.fromString(json.get("id").getAsString()));
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return Optional.empty();
                }
            }
            client.close();
        }
        return optional;
    }
}

