/*
 * Decompiled with CFR 0.152.
 */
package com.github.justinwon777.humancompanions.client;

import com.github.justinwon777.humancompanions.container.CompanionContainer;
import com.github.justinwon777.humancompanions.core.PacketHandler;
import com.github.justinwon777.humancompanions.entity.AbstractHumanCompanionEntity;
import com.github.justinwon777.humancompanions.entity.Arbalist;
import com.github.justinwon777.humancompanions.entity.Archer;
import com.github.justinwon777.humancompanions.entity.Knight;
import com.github.justinwon777.humancompanions.networking.ClearTargetPacket;
import com.github.justinwon777.humancompanions.networking.ReleasePacket;
import com.github.justinwon777.humancompanions.networking.SetAlertPacket;
import com.github.justinwon777.humancompanions.networking.SetHuntingPacket;
import com.github.justinwon777.humancompanions.networking.SetPatrolingPacket;
import com.github.justinwon777.humancompanions.networking.SetStationeryPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompanionScreen
extends AbstractContainerScreen<CompanionContainer>
implements MenuAccess<CompanionContainer> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("humancompanions", "textures/inventory.png");
    private static final ResourceLocation ALERT_BUTTON = new ResourceLocation("humancompanions", "textures/alertbutton.png");
    private static final ResourceLocation HUNTING_BUTTON = new ResourceLocation("humancompanions", "textures/huntingbutton.png");
    private static final ResourceLocation PATROL_BUTTON = new ResourceLocation("humancompanions", "textures/patrolbutton.png");
    private static final ResourceLocation CLEAR_BUTTON = new ResourceLocation("humancompanions", "textures/clearbutton.png");
    private static final ResourceLocation STATIONERY_BUTTON = new ResourceLocation("humancompanions", "textures/stationerybutton.png");
    private static final ResourceLocation RELEASE_BUTTON = new ResourceLocation("humancompanions", "textures/releasebutton.png");
    private final int containerRows;
    private final AbstractHumanCompanionEntity companion;
    private CompanionButton alertButton;
    private CompanionButton huntingButton;
    private CompanionButton patrolButton;
    private CompanionButton clearButton;
    private CompanionButton stationeryButton;
    private CompanionButton releaseButton;
    DecimalFormat df = new DecimalFormat("#.#");
    int sidebarx;
    int rowHeight;
    int colwidth;
    int row1;
    int row2;
    int row3;
    int col1;
    int col2;

    public CompanionScreen(CompanionContainer p_98409_, Inventory p_98410_, AbstractHumanCompanionEntity companion) {
        super((AbstractContainerMenu)p_98409_, p_98410_, companion.m_7755_());
        this.companion = companion;
        this.f_96546_ = false;
        this.containerRows = p_98409_.getRowCount();
        this.f_97727_ = 114 + this.containerRows * 18;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97726_ = 226;
        this.df.setRoundingMode(RoundingMode.CEILING);
        this.sidebarx = 174;
        this.rowHeight = 15;
        this.colwidth = 19;
    }

    public void m_6305_(PoseStack p_98418_, int p_98419_, int p_98420_, float p_98421_) {
        this.m_7333_(p_98418_);
        super.m_6305_(p_98418_, p_98419_, p_98420_, p_98421_);
        this.m_7025_(p_98418_, p_98419_, p_98420_);
    }

    protected void m_7286_(PoseStack p_98413_, float p_98414_, int p_98415_, int p_98416_) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONTAINER_BACKGROUND);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(p_98413_, i, j, 0, 0, this.f_97726_, this.containerRows * 18 + 17);
        this.m_93228_(p_98413_, i, j + this.containerRows * 18 + 17, 0, 126, this.f_97726_, 96);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.row1 = this.f_97736_ + 66;
        this.row2 = this.row1 + this.rowHeight;
        this.row3 = this.row2 + this.rowHeight;
        this.col1 = this.f_97735_ + this.sidebarx + 3;
        this.col2 = this.col1 + this.colwidth;
        this.alertButton = (CompanionButton)this.m_142416_((GuiEventListener)new CompanionButton("alert", this.col1, this.row1, 16, 12, 0, 0, 13, ALERT_BUTTON, btn -> PacketHandler.INSTANCE.sendToServer((Object)new SetAlertPacket(this.companion.m_142049_()))));
        this.huntingButton = (CompanionButton)this.m_142416_((GuiEventListener)new CompanionButton("hunting", this.col2, this.row1, 16, 12, 0, 0, 13, HUNTING_BUTTON, btn -> PacketHandler.INSTANCE.sendToServer((Object)new SetHuntingPacket(this.companion.m_142049_()))));
        this.patrolButton = (CompanionButton)this.m_142416_((GuiEventListener)new CompanionButton("patrolling", this.col1, this.row2, 16, 12, 0, 0, 13, PATROL_BUTTON, btn -> PacketHandler.INSTANCE.sendToServer((Object)new SetPatrolingPacket(this.companion.m_142049_()))));
        if (this.companion instanceof Archer || this.companion instanceof Arbalist) {
            this.stationeryButton = (CompanionButton)this.m_142416_((GuiEventListener)new CompanionButton("stationery", this.col2, this.row2, 16, 12, 0, 0, 13, STATIONERY_BUTTON, btn -> PacketHandler.INSTANCE.sendToServer((Object)new SetStationeryPacket(this.companion.m_142049_()))));
        }
        this.clearButton = (CompanionButton)this.m_142416_((GuiEventListener)new CompanionButton("clear", this.f_97735_ + this.sidebarx + 5, this.row3, 31, 12, 0, 0, 13, CLEAR_BUTTON, btn -> PacketHandler.INSTANCE.sendToServer((Object)new ClearTargetPacket(this.companion.m_142049_()))));
        this.releaseButton = (CompanionButton)this.m_142416_((GuiEventListener)new CompanionButton("release", this.f_97735_ + this.sidebarx + 3, this.f_97736_ + 148, 34, 12, 0, 0, 13, RELEASE_BUTTON, btn -> {
            PacketHandler.INSTANCE.sendToServer((Object)new ReleasePacket(this.companion.m_142049_()));
            this.m_7379_();
        }));
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        super.m_7027_(pPoseStack, pMouseX, pMouseY);
        int classHeight = this.f_97729_ + 14;
        int classLeft = this.sidebarx + 4;
        TextComponent classTitle = new TextComponent("Class");
        TextComponent healthTitle = new TextComponent("Health");
        TextComponent health = new TextComponent(this.df.format(this.companion.m_21223_()) + "/" + (int)this.companion.m_21233_());
        this.f_96547_.m_92889_(pPoseStack, (Component)classTitle.m_130940_(ChatFormatting.UNDERLINE), (float)(this.sidebarx + 4), (float)(this.f_97729_ + 3), 0x404040);
        if (this.companion instanceof Arbalist) {
            this.f_96547_.m_92883_(pPoseStack, "Arbalist", (float)classLeft, (float)classHeight, 0x404040);
        } else if (this.companion instanceof Archer) {
            this.f_96547_.m_92883_(pPoseStack, "Archer", (float)classLeft, (float)classHeight, 0x404040);
        } else if (this.companion instanceof Knight) {
            this.f_96547_.m_92883_(pPoseStack, "Knight", (float)classLeft, (float)classHeight, 0x404040);
        } else {
            this.f_96547_.m_92883_(pPoseStack, "Axe", (float)classLeft, (float)classHeight, 0x404040);
        }
        this.f_96547_.m_92889_(pPoseStack, (Component)healthTitle.m_130940_(ChatFormatting.UNDERLINE), (float)(this.sidebarx + 4), (float)(this.f_97729_ + 26), 0x404040);
        this.f_96547_.m_92889_(pPoseStack, (Component)health, (float)(this.sidebarx + 4), (float)(this.f_97729_ + 37), 0x404040);
        this.f_96547_.m_92883_(pPoseStack, "Level " + this.companion.getExpLvl(), (float)this.sidebarx, (float)(this.f_97729_ + 49), 0x404040);
    }

    protected void m_7025_(PoseStack stack, int x, int y) {
        ArrayList<Object> tooltips;
        super.m_7025_(stack, x, y);
        if (this.alertButton.m_198029_()) {
            tooltips = new ArrayList<Object>();
            if (this.companion.isAlert()) {
                tooltips.add(new TextComponent("Alert mode: On"));
            } else {
                tooltips.add(new TextComponent("Alert mode: Off"));
            }
            tooltips.add(new TextComponent("Attacks nearby hostile mobs").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            this.m_169388_(stack, tooltips, Optional.empty(), x, y);
        }
        if (this.huntingButton.m_198029_()) {
            tooltips = new ArrayList();
            if (this.companion.isHunting()) {
                tooltips.add(new TextComponent("Hunting mode: On"));
            } else {
                tooltips.add(new TextComponent("Hunting mode: Off"));
            }
            tooltips.add(new TextComponent("Attacks nearby mobs for food").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            this.m_169388_(stack, tooltips, Optional.empty(), x, y);
        }
        if (this.patrolButton.m_198029_()) {
            tooltips = new ArrayList();
            if (this.companion.isFollowing()) {
                tooltips.add(new TextComponent("Follow"));
                tooltips.add(new TextComponent("Follows you").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            } else if (this.companion.isPatrolling()) {
                tooltips.add(new TextComponent("Patrol"));
                tooltips.add(new TextComponent("Patrols a 4 block radius").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            } else {
                tooltips.add(new TextComponent("Guard"));
                tooltips.add(new TextComponent("Stands at its position ready for action").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            }
            this.m_169388_(stack, tooltips, Optional.empty(), x, y);
        }
        if (this.clearButton.m_198029_()) {
            tooltips = new ArrayList();
            tooltips.add(new TextComponent("Clear target"));
            tooltips.add(new TextComponent("Useful if it gets stuck attacking").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            this.m_169388_(stack, tooltips, Optional.empty(), x, y);
        }
        if (this.releaseButton.m_198029_()) {
            tooltips = new ArrayList();
            tooltips.add(new TextComponent("Release Companion"));
            tooltips.add(new TextComponent("Releases companion from your command. It can be tamed again.").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            this.m_169388_(stack, tooltips, Optional.empty(), x, y);
        }
        if ((this.companion instanceof Archer || this.companion instanceof Arbalist) && this.stationeryButton.m_198029_()) {
            tooltips = new ArrayList();
            if (this.companion.isStationery()) {
                tooltips.add(new TextComponent("Stationery: On"));
            } else {
                tooltips.add(new TextComponent("Stationery: Off"));
            }
            tooltips.add(new TextComponent("Companion will not move while attacking in guard mode").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
            this.m_169388_(stack, tooltips, Optional.empty(), x, y);
        }
    }

    class CompanionButton
    extends ImageButton {
        private String name;

        public CompanionButton(String name, int p_94269_, int p_94270_, int p_94271_, int p_94272_, int p_94273_, int p_94274_, int p_94275_, ResourceLocation p_94276_, Button.OnPress p_94277_) {
            super(p_94269_, p_94270_, p_94271_, p_94272_, p_94273_, p_94274_, p_94275_, p_94276_, p_94277_);
            this.name = name;
        }

        public void m_6303_(PoseStack p_94282_, int p_94283_, int p_94284_, float p_94285_) {
            if (this.name.equals("alert")) {
                this.f_94224_ = CompanionScreen.this.companion.isAlert() ? 0 : 17;
            } else if (this.name.equals("hunting")) {
                this.f_94224_ = CompanionScreen.this.companion.isHunting() ? 0 : 17;
            } else if (this.name.equals("patrolling")) {
                this.f_94224_ = CompanionScreen.this.companion.isFollowing() ? 0 : (CompanionScreen.this.companion.isPatrolling() ? 17 : 34);
            } else if (this.name.equals("stationery")) {
                this.f_94224_ = CompanionScreen.this.companion.isStationery() ? 0 : 17;
            }
            RenderSystem.m_69478_();
            super.m_6303_(p_94282_, p_94283_, p_94284_, p_94285_);
            RenderSystem.m_69461_();
        }
    }
}

