/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.mixin;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.DCConfig;
import com.afunproject.dawncraft.effects.DawnCraftEffects;
import com.afunproject.dawncraft.integration.create.CreateCompat;
import com.afunproject.dawncraft.integration.sophisticatedbackpacks.SophisticatedBackpacksCompat;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayer
extends LivingEntity {
    @Shadow
    private Inventory f_36093_;
    @Shadow
    public int f_36079_;
    private TagKey<Item> valuables = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)Constants.loc("valuables"));

    protected MixinPlayer(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(at={@At(value="HEAD")}, method={"dropEquipment()V"}, cancellable=true)
    public void dropEquipment(CallbackInfo callback) {
        if ((Boolean)DCConfig.harderKeepInventory.get() == false | !this.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        this.m_36345_();
        for (List list : this.f_36093_.f_35979_) {
            this.handleItems(list, true);
        }
        callback.cancel();
    }

    public List<ItemStack> handleItems(List<ItemStack> items, boolean damageItems) {
        int amplifier = 1;
        if (this.m_21023_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get())) {
            amplifier = this.m_21124_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()).m_19564_() + 1;
        }
        for (int i = 0; i < items.size(); ++i) {
            LazyOptional optional;
            CompoundTag tag;
            ItemStack stack = items.get(i);
            if (stack.m_41763_() && damageItems) {
                stack.m_41721_((int)Math.min((double)stack.m_41776_(), (double)stack.m_41773_() + (double)amplifier * 0.02 * (double)stack.m_41776_()));
            }
            if (stack.m_204117_(this.valuables)) {
                int loss;
                if (this.f_19853_.f_46441_.nextInt(10) >= 3) continue;
                ItemStack drop = stack.m_41777_();
                int count = stack.m_41613_();
                int newCount = count - (loss = this.f_19796_.nextInt(0, stack.m_41613_()));
                if (newCount < 0) {
                    drop.m_41764_(stack.m_41613_());
                } else {
                    drop.m_41764_(loss);
                }
                stack.m_41764_(Math.max(0, newCount));
                this.m_7197_(drop, true, false);
                continue;
            }
            if (stack.m_41720_() == Blocks.f_50456_.m_5456_()) {
                tag = BlockItem.m_186336_((ItemStack)stack);
                if (tag == null || !tag.m_128425_("Items", 9)) continue;
                NonNullList shulker_items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)shulker_items);
                this.handleItems((List<ItemStack>)shulker_items, false);
                ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)shulker_items);
                BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)BlockEntityType.f_58939_, (CompoundTag)tag);
                continue;
            }
            if (ModList.get().isLoaded("sophisticatedbackpacks") && SophisticatedBackpacksCompat.isBackpack(stack.m_41720_()) && (optional = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
                int j;
                IItemHandler itemhandler = (IItemHandler)optional.resolve().get();
                ArrayList backpack_items = Lists.newArrayList();
                for (j = 0; j < itemhandler.getSlots(); ++j) {
                    backpack_items.add(itemhandler.getStackInSlot(j));
                }
                this.handleItems(backpack_items, false);
                for (j = 0; j < backpack_items.size(); ++j) {
                    ItemStack stack0 = itemhandler.getStackInSlot(j);
                    itemhandler.extractItem(j, stack0.m_41613_(), false);
                    itemhandler.insertItem(j, (ItemStack)backpack_items.get(j), false);
                }
            }
            if (!ModList.get().isLoaded("create") || !CreateCompat.isToolbox(stack.m_41720_()) || (tag = stack.m_41784_()) == null || !tag.m_128425_("Items", 9)) continue;
            NonNullList toolbox_items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)toolbox_items);
            this.handleItems((List<ItemStack>)toolbox_items, false);
            ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)toolbox_items);
            stack.m_41739_(tag);
        }
        return items;
    }

    @Inject(at={@At(value="HEAD")}, method={"getExperienceReward(Lnet/minecraft/world/entity/player/Player;)I"}, cancellable=true)
    protected void getExperienceReward(Player player, CallbackInfoReturnable<Integer> callback) {
        if ((Boolean)DCConfig.harderKeepInventory.get() == false | !this.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        if (this.m_21023_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get())) {
            this.m_6749_(-this.m_21124_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()).m_19564_() - 1);
        } else {
            this.m_6749_(-1);
        }
    }

    @Shadow
    protected abstract void m_36345_();

    @Shadow
    public abstract ItemEntity m_7197_(ItemStack var1, boolean var2, boolean var3);

    @Shadow
    public abstract void m_6749_(int var1);
}

