/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.invasion;

import com.afunproject.dawncraft.invasion.InvasionEntry;
import com.afunproject.dawncraft.invasion.InvasionKey;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InvasionRegistry {
    private static final Map<InvasionKey, InvasionEntry> ENTRIES = Maps.newHashMap();

    public static void register(InvasionEntry entry) {
        ENTRIES.put(InvasionKey.create(entry.name.toUpperCase(), entry.name), entry);
    }

    public static InvasionEntry getInvasion(String name) {
        return InvasionRegistry.getInvasion(InvasionKey.getKey(name));
    }

    public static List<InvasionEntry> getInvasions() {
        ArrayList invasions = Lists.newArrayList();
        for (InvasionEntry invasion : ENTRIES.values()) {
            invasions.add(invasion.copy());
        }
        return invasions;
    }

    public static List<String> getKeys() {
        return ENTRIES.keySet().stream().map(key -> key.toString()).toList();
    }

    public static InvasionEntry getInvasion(InvasionKey key) {
        return ENTRIES.get((Object)key);
    }
}

