/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.invasion;

import com.afunproject.dawncraft.invasion.InvasionHuntPlayerGoal;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.atlas.api.util.DirectionUtils;

public class InvasionEntry {
    protected final String name;
    protected final List<EntityType<?>> entities = Lists.newArrayList();

    public InvasionEntry(String name, EntityType<?> ... entities) {
        this.name = name;
        for (EntityType<?> entity : entities) {
            this.entities.add(entity);
        }
    }

    public InvasionEntry(CompoundTag tag) {
        this.name = tag.m_128461_("name");
        for (Tag value : tag.m_128437_("tag", 8)) {
            try {
                ResourceLocation loc = new ResourceLocation(((StringTag)value).m_7916_());
                this.entities.add((EntityType)ForgeRegistries.ENTITIES.getValue(loc));
            }
            catch (Exception exception) {}
        }
    }

    public void spawnEntities(Player player) {
        Level level = player.f_19853_;
        for (EntityType<?> type : this.entities) {
            Vec3 dir = DirectionUtils.getRandomDirectionVecXZ((Random)player.m_21187_());
            BlockPos pos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_142538_(), (Vec3)dir, (double)50.0);
            Mob entity = (Mob)type.m_20615_(level);
            entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            DifficultyInstance difficulty = level.m_6436_(pos);
            entity.m_6518_((ServerLevelAccessor)level, difficulty, null, null, null);
            entity.m_21051_(Attributes.f_22277_).m_22100_(100.0);
            if (entity instanceof PathfinderMob) {
                entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
            }
            entity.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(entity, Player.class, true));
            entity.f_21345_.m_25352_(6, (Goal)new InvasionHuntPlayerGoal(entity, player));
            entity.m_21530_();
            level.m_7967_((Entity)entity);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 1000));
            Vec3 sound = player.m_20182_().m_82549_(dir);
            level.m_6263_(null, sound.f_82479_, sound.f_82480_, sound.f_82481_, SoundEvents.f_12287_, SoundSource.HOSTILE, 1.0f, level.f_46441_.nextFloat());
            player.m_5661_((Component)new TranslatableComponent("message.dawncraft.invasion", new Object[]{this.name}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131136_(Boolean.valueOf(true))), true);
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", this.name);
        ListTag list = new ListTag();
        for (EntityType<?> type : this.entities) {
            list.add((Object)StringTag.m_129297_((String)type.getRegistryName().toString()));
        }
        tag.m_128365_("entities", (Tag)list);
        return tag;
    }

    public InvasionEntry copy() {
        return new InvasionEntry(this.name, this.entities.toArray(new EntityType[0]));
    }
}

