/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.network;

import com.afunproject.dawncraft.integration.quests.client.QuestClientEvents;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import com.afunproject.dawncraft.integration.quests.network.OpenQuestMessage;
import com.afunproject.dawncraft.integration.quests.network.TriggerQuestCompleteMessage;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.smileycorp.atlas.api.network.SimpleMessageDecoder;
import net.smileycorp.atlas.api.network.SimpleMessageEncoder;

public class QuestNetworkHandler {
    public static void initPackets() {
        DCNetworkHandler.NETWORK_INSTANCE.registerMessage(1, TriggerQuestCompleteMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(TriggerQuestCompleteMessage.class), (T, K) -> QuestNetworkHandler.processQuestCompleteMessage(T, (NetworkEvent.Context)K.get()));
        DCNetworkHandler.NETWORK_INSTANCE.registerMessage(2, OpenQuestMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(OpenQuestMessage.class), (T, K) -> QuestNetworkHandler.processOpenQuestMessage(T, (NetworkEvent.Context)K.get()));
    }

    public static void processQuestCompleteMessage(TriggerQuestCompleteMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            Mob entity = message.get(ctx.getSender().f_19853_);
            QuestEntity questEntity = QuestEntity.safeCast((Entity)entity);
            Quest quest = questEntity.getCurrentQuest();
            if (quest != null) {
                quest.completeQuest((Player)ctx.getSender(), entity, questEntity.getQuestPhase(), message.isAccepted());
            }
        });
        ctx.setPacketHandled(true);
    }

    private static void processOpenQuestMessage(OpenQuestMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> QuestClientEvents.openQuestGUI(message)));
        ctx.setPacketHandled(true);
    }
}

