/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests.dc;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.effects.DawnCraftEffects;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.conditions.AndCondition;
import com.afunproject.dawncraft.integration.quests.custom.conditions.TagCondition;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntityBase;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import tictim.paraglider.contents.Contents;

public class WitchQuest
extends Quest {
    protected final int end_phase;

    public WitchQuest() {
        super(new AndCondition((player, entity, phase, isTest) -> phase == 2), new TagCondition(Constants.loc("bat_wing")), new TagCondition(Constants.loc("bark")), new TagCondition(Constants.loc("spider_eye")), new TagCondition(Constants.loc("honeycomb")), new TagCondition(Constants.loc("rabbit_foot")), new TagCondition(Constants.loc("bear_pelt")), new TagCondition(Constants.loc("emerald")));
        this.end_phase = 3;
    }

    @Override
    public void completeQuest(Player quest_completer, Mob entity, int phase, boolean accepted) {
        if (phase == this.end_phase) {
            if (entity instanceof QuestEntityBase) {
                ((QuestEntityBase)entity).setDespawnable(true);
            }
            ItemStack stack = new ItemStack((ItemLike)Contents.SPIRIT_ORB.get(), 4);
            this.giveItem(quest_completer, stack);
            quest_completer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20));
            entity.m_142467_(Entity.RemovalReason.DISCARDED);
        } else if (phase == 1 && accepted) {
            this.setPhase(entity, phase + 1);
        }
        if (entity instanceof QuestEntity) {
            ((QuestEntity)entity).setQuestText(this.getText(((QuestEntity)entity).getQuestPhase(), accepted));
        }
    }

    @Override
    public void onHurt(Mob entity, DamageSource source) {
        entity.m_5634_(entity.m_21233_());
        if (source.m_7639_() instanceof LivingEntity && source.m_7639_().m_6084_()) {
            ((LivingEntity)source.m_7639_()).m_7292_(new MobEffectInstance((MobEffect)DawnCraftEffects.FROGFORM.get(), 1200));
        }
    }

    @Override
    public void onDeath(Mob entity, DamageSource source) {
        entity.f_19853_.m_7967_((Entity)new ItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), new ItemStack((ItemLike)Contents.SPIRIT_ORB.get())));
        ((LivingEntity)source.m_7639_()).m_7292_(new MobEffectInstance((MobEffect)DawnCraftEffects.FROGFORM.get(), 7200));
    }

    @Override
    public String getText(int phase, boolean accepted) {
        return "text.dawncraft.quest.witch" + phase;
    }

    @Override
    public QuestType getQuestType(int phase) {
        if (phase == this.end_phase) {
            return QuestType.AUTO_CLOSE;
        }
        if (phase % 2 == 1) {
            return QuestType.ACCEPT_QUEST;
        }
        return QuestType.DENY;
    }

    @Override
    public boolean isQuestActive(Mob entity, int phase) {
        return true;
    }
}

