/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.integration.quests.custom.quests.Quest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.AlchemistQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.BarrelQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.BellGhostQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.CultQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.IntroQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.KingQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.MaskGhostQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.MonsterSlayerQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.SageQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.SorcererQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.WerewolfQuest;
import com.afunproject.dawncraft.integration.quests.custom.quests.dc.WitchQuest;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class QuestsRegistry {
    private static final Map<ResourceLocation, Quest> QUESTS = Maps.newHashMap();

    public static Quest registerQuest(ResourceLocation registry, Quest quest) {
        quest.setRegistryName(registry);
        QUESTS.put(registry, quest);
        return quest;
    }

    public static Quest getQuest(ResourceLocation registry) {
        return QUESTS.get(registry);
    }

    public static void registerDCQuests() {
        QuestsRegistry.registerQuest(Constants.loc("intro"), new IntroQuest());
        QuestsRegistry.registerQuest(Constants.loc("werewolf"), new WerewolfQuest());
        QuestsRegistry.registerQuest(Constants.loc("ghost"), new BellGhostQuest());
        QuestsRegistry.registerQuest(Constants.loc("cult"), new CultQuest());
        QuestsRegistry.registerQuest(Constants.loc("barrel"), new BarrelQuest());
        QuestsRegistry.registerQuest(Constants.loc("alchemist"), new AlchemistQuest());
        QuestsRegistry.registerQuest(Constants.loc("mask_ghost"), new MaskGhostQuest());
        QuestsRegistry.registerQuest(Constants.loc("witch"), new WitchQuest());
        QuestsRegistry.registerQuest(Constants.loc("king"), new KingQuest());
        QuestsRegistry.registerQuest(Constants.loc("monster_slayer"), new MonsterSlayerQuest());
        QuestsRegistry.registerQuest(Constants.loc("sage"), new SageQuest());
        QuestsRegistry.registerQuest(Constants.loc("sorcerer"), new SorcererQuest());
    }

    static {
        QuestsRegistry.registerDCQuests();
    }
}

