/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.custom.quests;

import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.custom.conditions.QuestCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public abstract class Quest {
    protected ResourceLocation registry;
    protected QuestCondition[] conditions;

    public Quest(QuestCondition ... conditions) {
        this.conditions = conditions;
    }

    void setRegistryName(ResourceLocation registry) {
        this.registry = registry;
    }

    public ResourceLocation getRegistryName() {
        return this.registry;
    }

    public boolean isQuestComplete(Player player, Mob entity, int phase) {
        for (QuestCondition condition : this.conditions) {
            if (condition.apply(player, entity, phase, true)) continue;
            return false;
        }
        for (QuestCondition condition : this.conditions) {
            condition.apply(player, entity, phase, false);
        }
        return true;
    }

    protected void setPhase(Mob entity, int phase) {
        QuestEntity.safeCast((Entity)entity).setQuestPhase(phase);
    }

    public void onDeath(Mob entity, DamageSource source) {
    }

    public void onHurt(Mob entity, DamageSource source) {
    }

    public abstract void completeQuest(Player var1, Mob var2, int var3, boolean var4);

    public abstract String getText(int var1, boolean var2);

    public abstract QuestType getQuestType(int var1);

    public abstract boolean isQuestActive(Mob var1, int var2);

    protected final void giveItem(Player player, ItemStack stack) {
        if (!player.m_36356_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    protected final ItemStack createMap(ServerLevel level, BlockPos center, ResourceLocation structure, String name) {
        TagKey structureTag = TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)structure);
        BlockPos blockpos = level.m_207561_(structureTag, center, 5000, false);
        if (blockpos != null) {
            ItemStack itemstack = MapItem.m_42886_((Level)level, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)1, (boolean)true, (boolean)true);
            MapItem.m_42850_((ServerLevel)level, (ItemStack)itemstack);
            MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
            return itemstack;
        }
        return MapItem.m_42886_((Level)level, (int)center.m_123341_(), (int)center.m_123343_(), (byte)2, (boolean)true, (boolean)true);
    }
}

