/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests.client.screens;

import com.afunproject.dawncraft.client.EntityRenderProperties;
import com.afunproject.dawncraft.integration.quests.client.screens.OptionsPage;
import com.afunproject.dawncraft.integration.quests.client.screens.Page;
import com.afunproject.dawncraft.integration.quests.client.screens.TextPage;
import com.afunproject.dawncraft.integration.quests.custom.QuestType;
import com.afunproject.dawncraft.integration.quests.network.TriggerQuestCompleteMessage;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import com.feywild.quest_giver.screen.button.QuestButton;
import com.feywild.quest_giver.screen.button.QuestButtonSmall;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class QuestScreen
extends Screen {
    private static final int TEXT_WIDTH = 56;
    protected final Mob entity;
    protected final QuestType questType;
    protected List<Page> pages = Lists.newArrayList();
    protected Random random = new Random();
    protected final Style style;
    protected int pageIndex = 0;
    protected final Button NEXT_PAGE;

    public QuestScreen(Mob entity, MutableComponent text, QuestType questType) {
        super(entity.m_7755_());
        this.entity = entity;
        this.questType = questType;
        this.style = text.m_7383_();
        this.NEXT_PAGE = new QuestButtonSmall(380, 120, true, entity.m_142538_(), (Component)new TranslatableComponent("text.dawncraft.next"), button -> {
            if (this.pageIndex == this.pages.size() - 1) {
                this.completeQuest(true);
                this.m_7379_();
                return;
            }
            ++this.pageIndex;
        });
        if (questType == QuestType.OPTIONS) {
            String[] pages = text.getString().split("\u00b6");
            if (pages.length == 0) {
                this.pages.addAll(QuestScreen.generatePages(this, text));
            }
            if (pages.length > 1) {
                for (int i = 0; i < pages.length - 2; ++i) {
                    this.pages.addAll(QuestScreen.generatePages(this, (MutableComponent)new TranslatableComponent(pages[i])));
                }
            }
            Object[] options = pages[pages.length - 1].split("\u00a6");
            this.pages.add(new OptionsPage(this, Lists.newArrayList((Object[])options)));
        } else {
            this.pages.addAll(QuestScreen.generatePages(this, text));
        }
    }

    public static List<Page> generatePages(QuestScreen screen, MutableComponent text) {
        ArrayList pages = Lists.newArrayList();
        if (text != null) {
            String str = text.getString();
            int position = 0;
            ArrayList lines = Lists.newArrayList();
            if (str.length() == 0) {
                lines.add(new TranslatableComponent("text.afptweaks.quest.no_text").getString());
            }
            block0: while (position < str.length()) {
                int i;
                int size = Math.min(56, str.length() - position);
                int newPos = position + size;
                if (str.substring(position, newPos).contains("\u00b6")) {
                    i = str.substring(position, newPos).indexOf("\u00b6");
                    lines.add(str.substring(position, position + i));
                    pages.add(new TextPage(screen, lines, screen.NEXT_PAGE));
                    lines = Lists.newArrayList();
                    position = position + i + 1;
                    continue;
                }
                if (str.substring(position, newPos).contains("\u00ac")) {
                    i = str.substring(position, newPos).indexOf("\u00ac");
                    lines.add(str.substring(position, position + i));
                    position = position + i + 1;
                    if (lines.size() < 9) continue;
                    pages.add(new TextPage(screen, lines, screen.NEXT_PAGE));
                    lines = Lists.newArrayList();
                    continue;
                }
                if (size < 56) {
                    lines.add(str.substring(position));
                    break;
                }
                for (i = 0; i <= size; ++i) {
                    if (i == size) {
                        lines.add(str.substring(position, newPos + 1));
                        position = newPos;
                        if (lines.size() < 9) continue block0;
                        pages.add(new TextPage(screen, lines, screen.NEXT_PAGE));
                        lines = Lists.newArrayList();
                        continue block0;
                    }
                    if (str.charAt(newPos - i) != ' ') continue;
                    lines.add(str.substring(position, newPos - i + 1));
                    position = newPos - i + 1;
                    if (lines.size() < 9) continue block0;
                    pages.add(new TextPage(screen, lines, screen.NEXT_PAGE));
                    lines = Lists.newArrayList();
                    continue block0;
                }
            }
            if (screen.questType == QuestType.AUTO_CLOSE) {
                pages.add(new TextPage(screen, lines, screen.NEXT_PAGE));
            } else {
                pages.add(new TextPage(screen, lines, screen.getAcceptButtons()));
            }
        } else {
            pages.add(new TextPage(screen, Lists.newArrayList((Object[])new String[]{new TranslatableComponent("text.afptweaks.quest.no_text", new Object[]{"null"}).getString()}), screen.NEXT_PAGE));
        }
        return pages;
    }

    private void completeQuest(boolean accepted) {
        DCNetworkHandler.NETWORK_INSTANCE.sendToServer((Object)new TriggerQuestCompleteMessage(this.entity, accepted));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int entityX = 37;
        int entityY = 240;
        int size = 65;
        EntityRenderProperties.setRenderNameplate(false);
        InventoryScreen.m_98850_((int)entityX, (int)entityY, (int)size, (float)(entityX - mouseX), (float)((float)entityY + this.entity.m_20192_() - (float)mouseY), (LivingEntity)this.entity);
        EntityRenderProperties.setRenderNameplate(true);
        if (this.pages.size() > 0) {
            this.pages.get(this.pageIndex).render(poseStack, mouseX, mouseY, partialTicks);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_95587_) {
        if (this.pages.size() > 0) {
            for (AbstractWidget widget : this.pages.get(this.pageIndex).getWidgets()) {
                if (!widget.m_5953_(mouseX, mouseY)) continue;
                widget.m_6375_(mouseX, mouseY, p_95587_);
            }
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return this.questType == QuestType.OPTIONS;
    }

    private Button[] getAcceptButtons() {
        if (this.questType == QuestType.ACCEPT_QUEST) {
            return new Button[]{new QuestButton(380, 190, true, this.entity.m_142538_(), (Component)this.getRandomAcceptMessage(), button1 -> {
                this.completeQuest(true);
                this.m_7379_();
            }), new QuestButton(380, 218, false, this.entity.m_142538_(), (Component)this.getRandomDeclineMessage(), button1 -> {
                this.completeQuest(false);
                this.m_7379_();
            })};
        }
        if (this.questType == QuestType.ACKNOWLEDGE) {
            TranslatableComponent msg1 = this.getRandomAcknowledgmentMessage();
            TranslatableComponent msg2 = this.getRandomAcknowledgmentMessage();
            while (msg1.equals((Object)msg2)) {
                msg2 = this.getRandomAcknowledgmentMessage();
            }
            return new Button[]{new QuestButton(380, 190, true, this.entity.m_142538_(), (Component)msg1, button1 -> {
                this.completeQuest(true);
                this.m_7379_();
            }), new QuestButton(380, 218, false, this.entity.m_142538_(), (Component)msg2, button1 -> {
                this.completeQuest(true);
                this.m_7379_();
            })};
        }
        if (this.questType == QuestType.DENY) {
            TranslatableComponent msg1 = this.getRandomDenyMessage();
            TranslatableComponent msg2 = this.getRandomDenyMessage();
            while (msg1.equals((Object)msg2)) {
                msg2 = this.getRandomDenyMessage();
            }
            return new Button[]{new QuestButton(380, 190, true, this.entity.m_142538_(), (Component)msg1, button1 -> {
                this.completeQuest(false);
                this.m_7379_();
            }), new QuestButton(380, 218, false, this.entity.m_142538_(), (Component)msg2, button1 -> {
                this.completeQuest(false);
                this.m_7379_();
            })};
        }
        return new Button[0];
    }

    private TranslatableComponent getRandomAcknowledgmentMessage() {
        return new TranslatableComponent("text.dawncraft.acknowledge" + (this.random.nextInt(5) + 1));
    }

    private TranslatableComponent getRandomDenyMessage() {
        return new TranslatableComponent("text.dawncraft.deny" + (this.random.nextInt(4) + 1));
    }

    private TranslatableComponent getRandomAcceptMessage() {
        return new TranslatableComponent("text.dawncraft.accept" + (this.random.nextInt(5) + 1));
    }

    private TranslatableComponent getRandomDeclineMessage() {
        return new TranslatableComponent("text.dawncraft.decline" + (this.random.nextInt(5) + 1));
    }
}

