/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.EventListener;
import com.afunproject.dawncraft.event.DCSubCommandsEvent;
import com.afunproject.dawncraft.integration.quests.FollowMeQuestEvents;
import com.afunproject.dawncraft.integration.quests.QuestNPC;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntities;
import com.afunproject.dawncraft.integration.quests.custom.entity.QuestEntityBase;
import com.afunproject.dawncraft.integration.quests.network.QuestNetworkHandler;
import com.afunproject.dawncraft.integration.quests.task.AdvancementTask;
import com.feywild.quest_giver.quest.player.QuestData;
import com.feywild.quest_giver.quest.task.TaskType;
import com.feywild.quest_giver.quest.task.TaskTypes;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.command.EnumArgument;

public class QuestEvents {
    public static void init() {
        TaskTypes.register((ResourceLocation)Constants.loc("advancement"), (TaskType)AdvancementTask.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new QuestEvents());
        QuestEntities.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        EventListener.ATTRIBUTE_SUPPLIERS.add(QuestEvents::registerAttributes);
        QuestNetworkHandler.initPackets();
        if (ModList.get().isLoaded("followme")) {
            MinecraftForge.EVENT_BUS.register((Object)new FollowMeQuestEvents());
        }
    }

    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)QuestEntities.FALLEN_ADVENTURER.get(), QuestEntityBase.createDefaultAttributes());
        event.put((EntityType)QuestEntities.QUEST_PLAYER.get(), QuestEntityBase.createDefaultAttributes());
    }

    @SubscribeEvent
    public void advancementTrigger(AdvancementEvent event) {
        QuestData quests = QuestData.get((ServerPlayer)((ServerPlayer)event.getPlayer()));
        quests.checkComplete((TaskType)AdvancementTask.INSTANCE, (Object)event.getAdvancement());
    }

    @SubscribeEvent
    public void registerSubCommands(DCSubCommandsEvent event) {
        event.addSubCommand((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawnNPC").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"npc", (ArgumentType)EnumArgument.enumArgument(QuestNPC.class)).executes(ctx -> QuestEvents.spawnNPCNoPos((CommandContext<CommandSourceStack>)ctx))).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> QuestEvents.spawnNPC((CommandContext<CommandSourceStack>)ctx))))));
    }

    public static int spawnNPC(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        WorldCoordinates pos = (WorldCoordinates)ctx.getArgument("pos", WorldCoordinates.class);
        QuestEvents.spawnNPC(ctx, pos.m_6955_((CommandSourceStack)ctx.getSource()));
        return 0;
    }

    public static int spawnNPCNoPos(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        QuestEvents.spawnNPC(ctx, ((CommandSourceStack)ctx.getSource()).m_81371_());
        return 0;
    }

    private static void spawnNPC(CommandContext<CommandSourceStack> ctx, Vec3 pos) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        QuestNPC npc = (QuestNPC)((Object)ctx.getArgument("npc", QuestNPC.class));
        npc.spawnEntity((Level)source.m_81372_(), pos);
        source.m_81354_((Component)new TranslatableComponent("message.dawncraft.spawn_npc", new Object[]{npc, pos}), false);
    }
}

