/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.quests;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.ModUtils;
import com.afunproject.dawncraft.capability.CapabilitiesRegister;
import com.afunproject.dawncraft.capability.FollowQuest;
import com.afunproject.dawncraft.integration.quests.task.FollowTask;
import com.feywild.quest_giver.entity.QuestGuardVillager;
import com.feywild.quest_giver.quest.player.QuestData;
import com.feywild.quest_giver.quest.task.TaskType;
import com.feywild.quest_giver.quest.task.TaskTypes;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.smileycorp.followme.common.FollowHandler;
import net.smileycorp.followme.common.FollowMe;
import net.smileycorp.followme.common.ai.FollowUserGoal;
import net.smileycorp.followme.common.capability.IFollower;

public class FollowMeQuestEvents {
    public FollowMeQuestEvents() {
        TaskTypes.register((ResourceLocation)Constants.loc("follow_quest"), (TaskType)FollowTask.INSTANCE);
    }

    @SubscribeEvent
    public void entityTick(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof Mob) {
            IFollower followCap;
            LivingEntity followedEntity;
            LazyOptional followOptional;
            FollowQuest questCap;
            LazyOptional questOptional;
            Mob entity = (Mob)event.getEntity();
            if (entity.f_19853_ instanceof ServerLevel && (questOptional = entity.getCapability(CapabilitiesRegister.FOLLOW_QUEST)).isPresent() && (questCap = (FollowQuest)questOptional.resolve().get()).hasStructure() && (followOptional = entity.getCapability(FollowMe.FOLLOW_CAPABILITY)).isPresent() && (followedEntity = (followCap = (IFollower)followOptional.resolve().get()).getFollowedEntity()) instanceof ServerPlayer) {
                QuestData quests;
                if (FollowMeQuestEvents.isInStructure(entity.m_142538_(), (ServerLevel)entity.f_19853_, questCap.getStructure())) {
                    QuestData quests2 = QuestData.get((ServerPlayer)((ServerPlayer)followedEntity));
                    if (quests2.checkComplete((TaskType)FollowTask.INSTANCE, (Object)questCap.getStructure())) {
                        for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                            if (!(entry.m_26015_() instanceof FollowUserGoal)) continue;
                            FollowUserGoal task = (FollowUserGoal)entry.m_26015_();
                            if (task.getUser() != followedEntity) break;
                            FollowHandler.removeAI((FollowUserGoal)task);
                            break;
                        }
                        followCap.setForcedToFollow(false);
                        questCap.setStructure(null);
                    }
                } else if (questCap.getStructure().equals("#minecraft:village") & !entity.f_19853_.m_45976_(QuestGuardVillager.class, entity.m_142469_().m_82400_(10.0)).isEmpty() && (quests = QuestData.get((ServerPlayer)((ServerPlayer)followedEntity))).checkComplete((TaskType)FollowTask.INSTANCE, (Object)questCap.getStructure())) {
                    for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                        if (!(entry.m_26015_() instanceof FollowUserGoal)) continue;
                        FollowUserGoal task = (FollowUserGoal)entry.m_26015_();
                        if (task.getUser() != followedEntity) break;
                        FollowHandler.removeAI((FollowUserGoal)task);
                        break;
                    }
                    followCap.setForcedToFollow(false);
                    questCap.setStructure(null);
                }
            }
        }
    }

    private static boolean isInStructure(BlockPos pos, ServerLevel level, String structure) {
        ResourceKey structureKey;
        if (structure.contains("#")) {
            return FollowMeQuestEvents.isInStructureTag(pos, level, structure.replace("#", ""));
        }
        if (!ModUtils.isValidResourceLocation(structure)) {
            return false;
        }
        Registry registry = level.m_5962_().m_175515_(Registry.f_122882_);
        Optional structureOptional = registry.m_203636_(structureKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation(structure)));
        if (structureOptional.isPresent()) {
            Pair pair = level.m_7726_().m_8481_().m_207970_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)structureOptional.get()}), pos, 1, false);
            if (pair == null) {
                return false;
            }
            BlockPos villagePos = (BlockPos)pair.getFirst();
            if (Math.abs(villagePos.m_123342_() - pos.m_123342_()) > 15) {
                return Math.pow(villagePos.m_123341_() - pos.m_123341_(), 2.0) + Math.pow(villagePos.m_123343_() - pos.m_123343_(), 2.0) <= 6400.0;
            }
        }
        return false;
    }

    private static boolean isInStructureTag(BlockPos pos, ServerLevel level, String structure) {
        TagKey structureTag;
        if (!ModUtils.isValidResourceLocation(structure)) {
            return false;
        }
        Registry registry = level.m_5962_().m_175515_(Registry.f_122882_);
        Optional structureOptional = registry.m_203431_(structureTag = TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation(structure)));
        if (structureOptional.isPresent()) {
            Pair pair = level.m_7726_().m_8481_().m_207970_(level, (HolderSet)structureOptional.get(), pos, 1, false);
            if (pair == null) {
                return false;
            }
            BlockPos villagePos = (BlockPos)pair.getFirst();
            return Math.pow(villagePos.m_123341_() - pos.m_123341_(), 2.0) + Math.pow(villagePos.m_123343_() - pos.m_123343_(), 2.0) <= 1024.0;
        }
        return false;
    }
}

