/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.integration.epicfight;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.model.ClientModels;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.api.model.Model;
import yesman.epicfight.api.utils.EpicFightDamageSource;
import yesman.epicfight.gameasset.Models;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EpicFightCompat {
    public static StaticAnimation EAT_LEFT;
    public static StaticAnimation EAT_RIGHT;
    public static StaticAnimation DRINK_LEFT;
    public static StaticAnimation DRINK_RIGHT;

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EpicFightCompat::registerAnimations);
        MinecraftForge.EVENT_BUS.register((Object)new EpicFightCompat());
    }

    public static void registerAnimations(AnimationRegistryEvent event) {
        event.getRegistryMap().put("dawncraft", EpicFightCompat::build);
    }

    private static void build() {
        ClientModels models = FMLEnvironment.dist == Dist.CLIENT ? ClientModels.LOGICAL_CLIENT : Models.LOGICAL_SERVER;
        Model biped = models.biped;
        EAT_LEFT = new MainFrameAnimation(0.15f, "biped/living/eat_left", biped);
        EAT_RIGHT = new MainFrameAnimation(0.15f, "biped/living/eat_right", biped);
        DRINK_LEFT = new MainFrameAnimation(0.15f, "biped/living/drink_left", biped);
        DRINK_RIGHT = new MainFrameAnimation(0.15f, "biped/living/drink_right", biped);
    }

    @SubscribeEvent
    public void itemTick(LivingEntityUseItemEvent.Tick event) {
        if (event.getEntityLiving() instanceof Player) {
            LazyOptional optional;
            Player player = (Player)event.getEntityLiving();
            ItemStack stack = event.getItem();
            if (stack.m_41780_() == UseAnim.EAT) {
                LazyOptional optional2 = player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY);
                if (optional2.isPresent()) {
                    ((LivingEntityPatch)optional2.resolve().get()).playAnimationSynchronized(player.m_5737_() == HumanoidArm.LEFT && player.m_7655_() == InteractionHand.MAIN_HAND || player.m_7655_() == InteractionHand.OFF_HAND ? EAT_LEFT : EAT_RIGHT, 0.0f);
                }
            } else if (stack.m_41780_() == UseAnim.DRINK && (optional = player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY)).isPresent()) {
                ((LivingEntityPatch)optional.resolve().get()).playAnimationSynchronized(player.m_5737_() == HumanoidArm.LEFT && player.m_7655_() == InteractionHand.MAIN_HAND || player.m_7655_() == InteractionHand.OFF_HAND ? DRINK_LEFT : DRINK_RIGHT, 0.0f);
            }
        }
    }

    @SubscribeEvent
    public void livingHurtEvent(LivingDamageEvent event) {
        DamageSource source;
        if (!event.getEntity().f_19853_.f_46443_ && (source = event.getSource()).m_19385_().equals("player") & !(source instanceof EpicFightDamageSource)) {
            event.setAmount(event.getAmount() / 2.0f);
        }
    }

    public static boolean isCombatMode(Player player) {
        LazyOptional optional = player.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY);
        return optional.isPresent() && ((PlayerPatch)optional.resolve().get()).isBattleMode();
    }
}

