/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.entities;

import com.afunproject.dawncraft.entities.DawnCraftEntities;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.smileycorp.atlas.api.util.DirectionUtils;

public class RitualItemEntity
extends Entity {
    public static final EntityDataSerializer<List<BlockPos>> POS_LIST_SERIALIZER = new EntityDataSerializer<List<BlockPos>>(){

        public void write(FriendlyByteBuf buf, List<BlockPos> positions) {
            for (BlockPos pos : positions) {
                buf.m_130064_(pos);
            }
        }

        public List<BlockPos> read(FriendlyByteBuf buf) {
            ArrayList positions = Lists.newArrayList();
            try {
                while (true) {
                    BlockPos pos = buf.m_130135_();
                    positions.add(pos);
                }
            }
            catch (Exception e) {
                return positions;
            }
        }

        public List<BlockPos> copy(List<BlockPos> list) {
            return Lists.newArrayList(list);
        }
    };
    public static final EntityDataAccessor<ItemStack> ITEM;
    public static final EntityDataAccessor<List<BlockPos>> PEDESTALS;
    protected ItemStack result = ItemStack.f_41583_;

    public RitualItemEntity(EntityType<? extends RitualItemEntity> p_31991_, Level p_31992_) {
        super(p_31991_, p_31992_);
    }

    public RitualItemEntity(Level level, ItemStack stack, ItemStack result, BlockPos pos, List<BlockPos> pedestals) {
        super((EntityType)DawnCraftEntities.RITUAL_ITEM.get(), level);
        this.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 1.5f, (float)pos.m_123343_() + 0.5f);
        this.f_19804_.m_135381_(ITEM, (Object)stack);
        this.result = result;
        this.f_19804_.m_135381_(PEDESTALS, pedestals);
        this.f_19794_ = true;
    }

    public boolean m_5825_() {
        return true;
    }

    public ItemStack getItem() {
        return (ItemStack)this.f_19804_.m_135370_(ITEM);
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void setItem(ItemStack stack) {
        this.f_19804_.m_135381_(ITEM, (Object)stack);
    }

    public void setResult(ItemStack stack) {
        this.result = stack;
    }

    public List<BlockPos> getPedestals() {
        return (List)this.f_19804_.m_135370_(PEDESTALS);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.m_6027_(this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.009, this.m_20182_().f_82481_);
            if (this.f_19796_.nextInt(30) == 0) {
                this.m_5496_(SoundEvents.f_12644_, 0.5f, this.f_19796_.nextFloat());
            }
            if (this.f_19797_ == 400) {
                ItemEntity drop = new ItemEntity(this.f_19853_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, this.result);
                this.m_6074_();
                this.f_19853_.m_7967_((Entity)drop);
                this.m_5496_(SoundEvents.f_11860_, 0.75f, 0.75f);
                LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
                bolt.m_146884_(this.m_20182_().m_82520_(0.0, -3.0, 0.0));
                bolt.m_20874_(true);
                this.f_19853_.m_7967_((Entity)bolt);
            }
        } else if (this.f_19797_ <= 330) {
            for (BlockPos pos : (List)this.f_19804_.m_135370_(PEDESTALS)) {
                Vec3 start = new Vec3((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                Vec3 dir = DirectionUtils.getDirectionVec((Vec3)start, (Vec3)this.m_20182_().m_82520_(0.0, 1.0, 0.0));
                Vec3 dir1 = DirectionUtils.getDirectionVecXZ((Vec3)this.m_20182_(), (Vec3)start);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123789_, start.f_82479_, start.f_82480_, start.f_82481_, dir.f_82479_ * 0.15, dir.f_82480_ * 0.15, dir.f_82481_ * 0.15);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20182_().f_82479_, start.f_82480_ - 0.5, this.m_20182_().f_82481_, dir1.f_82479_ * 0.1, dir1.f_82480_ * 0.1, dir1.f_82481_ * 0.1);
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(PEDESTALS, (Object)Lists.newArrayList());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("item")) {
            this.f_19804_.m_135381_(ITEM, (Object)ItemStack.m_41712_((CompoundTag)tag.m_128469_("item")));
        }
        if (tag.m_128441_("result")) {
            this.result = ItemStack.m_41712_((CompoundTag)tag.m_128469_("result"));
        }
        if (tag.m_128441_("pedestals")) {
            ArrayList pedestals = Lists.newArrayList();
            for (Tag pedestal : tag.m_128437_("pedestals", 10)) {
                CompoundTag pos = (CompoundTag)pedestal;
                pedestals.add(new BlockPos(pos.m_128451_("x"), pos.m_128451_("y"), pos.m_128451_("z")));
            }
            this.f_19804_.m_135381_(PEDESTALS, (Object)pedestals);
        }
    }

    protected void m_7380_(CompoundTag tag) {
        CompoundTag stack = ((ItemStack)this.f_19804_.m_135370_(ITEM)).m_41739_(new CompoundTag());
        CompoundTag result = this.result.m_41739_(new CompoundTag());
        ListTag pedestals = new ListTag();
        for (BlockPos pos : (List)this.f_19804_.m_135370_(PEDESTALS)) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            pedestals.add((Object)posTag);
        }
        tag.m_128365_("item", (Tag)stack);
        tag.m_128365_("result", (Tag)result);
        tag.m_128365_("pedestals", (Tag)pedestals);
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    static {
        EntityDataSerializers.m_135050_(POS_LIST_SERIALIZER);
        ITEM = SynchedEntityData.m_135353_(RitualItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        PEDESTALS = SynchedEntityData.m_135353_(RitualItemEntity.class, POS_LIST_SERIALIZER);
    }
}

