/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.dungeon.item;

import com.afunproject.dawncraft.dungeon.KeyColour;
import com.afunproject.dawncraft.dungeon.item.CursedMaskItem;
import com.afunproject.dawncraft.dungeon.item.DungeonConfiguratorItem;
import com.afunproject.dawncraft.dungeon.item.ExecutionerItem;
import com.afunproject.dawncraft.dungeon.item.KeyItem;
import com.afunproject.dawncraft.dungeon.item.LockItem;
import com.afunproject.dawncraft.dungeon.item.RebirthStaffItem;
import com.afunproject.dawncraft.dungeon.item.SkeletonKeyItem;
import com.afunproject.dawncraft.dungeon.item.SlayersBladeItem;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DungeonItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dawncraft");
    private static final Map<KeyColour, RegistryObject<Item>> KEY_MAP = Maps.newHashMap();
    private static final Map<KeyColour, RegistryObject<Item>> LOCK_MAP = Maps.newHashMap();
    public static final RegistryObject<Item> DUNGEON_CONFIGURATOR = ITEMS.register("dungeon_configurator", DungeonConfiguratorItem::new);
    public static final RegistryObject<Item> SKELETON_KEY = ITEMS.register("skeleton_key", SkeletonKeyItem::new);
    public static final RegistryObject<Item> CURSED_MASK = ITEMS.register("cursed_mask", CursedMaskItem::new);
    public static final RegistryObject<Item> REBIRTH_STAFF = ITEMS.register("rebirth_staff", RebirthStaffItem::new);
    public static final RegistryObject<Item> SLAYERS_BLADE = ITEMS.register("slayers_blade", SlayersBladeItem::new);
    public static final RegistryObject<Item> EXECUTIONER = ITEMS.register("executioner", ExecutionerItem::new);

    public static KeyItem getKey(KeyColour colour) {
        return (KeyItem)KEY_MAP.get((Object)colour).get();
    }

    public static LockItem getLock(KeyColour colour) {
        return (LockItem)((Object)LOCK_MAP.get((Object)colour).get());
    }

    static {
        for (KeyColour colour : KeyColour.values()) {
            KEY_MAP.put(colour, (RegistryObject<Item>)ITEMS.register(colour.getName() + "_key", () -> new KeyItem(colour)));
            LOCK_MAP.put(colour, (RegistryObject<Item>)ITEMS.register(colour.getName() + "_lock", () -> new LockItem(colour)));
        }
    }
}

