/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.dungeon.item;

import com.afunproject.dawncraft.CreativeTabs;
import com.afunproject.dawncraft.ModUtils;
import com.afunproject.dawncraft.dungeon.block.entity.interfaces.DungeonTrigger;
import com.afunproject.dawncraft.dungeon.block.entity.interfaces.Functional;
import com.afunproject.dawncraft.dungeon.block.entity.interfaces.SingleUse;
import com.afunproject.dawncraft.network.DCNetworkHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkDirection;
import net.smileycorp.atlas.api.network.SimpleStringMessage;

public class DungeonConfiguratorItem
extends Item {
    public DungeonConfiguratorItem() {
        super(new Item.Properties().m_41491_(CreativeTabs.DUNGEON_ITEMS).m_41487_(1));
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            this.setMode(stack, ConfiguratorMode.LINK_FUNCTIONAL);
            items.add((Object)stack);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        ConfiguratorMode mode = ConfiguratorMode.getmode(stack);
        lines.add((Component)new TranslatableComponent(mode.getModeMessage()).m_130940_(ChatFormatting.AQUA));
        lines.add((Component)mode.getTooltip());
        lines.add((Component)new TranslatableComponent("tooltip.dawncraft.configuratormode").m_130940_(ChatFormatting.YELLOW));
    }

    public Component m_7626_(ItemStack stack) {
        return ((BaseComponent)super.m_7626_(stack)).m_130940_(ChatFormatting.LIGHT_PURPLE);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return super.m_7203_(level, player, hand);
        }
        if (player.m_7500_()) {
            if (player.m_6047_()) {
                ConfiguratorMode mode = this.shiftMode(player.m_21120_(hand));
                if (player instanceof ServerPlayer) {
                    DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleStringMessage(mode.getModeMessage()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        } else {
            player.m_6352_((Component)new TranslatableComponent("message.dawncraft.creative_required"), null);
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        if (level.f_46443_) {
            return super.m_6225_(ctx);
        }
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43722_();
        BlockEntity block_entity = level.m_7702_(pos);
        BlockState state = level.m_8055_(pos);
        Player player = ctx.m_43723_();
        if (player.m_7500_()) {
            if (player.m_6047_()) {
                ConfiguratorMode mode = this.shiftMode(stack);
                if (player instanceof ServerPlayer) {
                    DCNetworkHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleStringMessage(mode.getModeMessage()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else {
                ConfiguratorMode mode = ConfiguratorMode.getmode(stack);
                switch (mode) {
                    case LINK_FUNCTIONAL: {
                        BlockPos linked_pos;
                        if (block_entity instanceof Functional) {
                            if (pos == null) break;
                            player.m_6352_((Component)new TranslatableComponent("message.dawncraft.select_functional_block", new Object[]{ModUtils.getPosString(pos)}), null);
                            this.setSelectedBlock(stack, pos);
                            break;
                        }
                        if (!(block_entity instanceof DungeonTrigger) || (linked_pos = DungeonConfiguratorItem.getSelectedPos(stack)) == null) break;
                        player.m_6352_((Component)new TranslatableComponent("message.dawncraft.link_triggerable_block", new Object[]{ModUtils.getPosString(linked_pos), ModUtils.getPosString(pos)}), null);
                        ((DungeonTrigger)block_entity).addLinkedBlock(level, linked_pos);
                        this.setSelectedBlock(stack, null);
                        break;
                    }
                    case UNLINK_FUNCTIONAL: {
                        BlockPos linked_pos;
                        if (block_entity instanceof Functional) {
                            if (pos == null) break;
                            player.m_6352_((Component)new TranslatableComponent("message.dawncraft.select_functional_block", new Object[]{ModUtils.getPosString(pos)}), null);
                            this.setSelectedBlock(stack, pos);
                            break;
                        }
                        if (!(block_entity instanceof DungeonTrigger) || (linked_pos = DungeonConfiguratorItem.getSelectedPos(stack)) == null) break;
                        player.m_6352_((Component)new TranslatableComponent("message.dawncraft.unlink_triggerable_block", new Object[]{ModUtils.getPosString(linked_pos), ModUtils.getPosString(pos)}), null);
                        ((DungeonTrigger)block_entity).removeLinkedBlock(linked_pos);
                        this.setSelectedBlock(stack, null);
                        break;
                    }
                    case RESET_FUNCTIONAL: {
                        if (!(block_entity instanceof SingleUse) || !((SingleUse)block_entity).hasBeenUsed()) break;
                        ((SingleUse)block_entity).reset();
                        player.m_6352_((Component)new TranslatableComponent("message.dawncraft.reset_functional_block", new Object[]{ModUtils.getPosString(pos)}), null);
                        break;
                    }
                    case ROTATE: {
                        if (state == null) break;
                        state.rotate((LevelAccessor)level, pos, Rotation.CLOCKWISE_90);
                        break;
                    }
                    default: {
                        player.m_6352_((Component)new TranslatableComponent("message.dawncraft.no_mode", new Object[]{mode}), null);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        player.m_6352_((Component)new TranslatableComponent("message.dawncraft.creative_required"), null);
        return super.m_6225_(ctx);
    }

    public ConfiguratorMode shiftMode(ItemStack stack) {
        ConfiguratorMode mode = ConfiguratorMode.getmode(stack);
        ConfiguratorMode newMode = ConfiguratorMode.values()[(mode.ordinal() + 1) % ConfiguratorMode.values().length];
        this.setMode(stack, newMode);
        return newMode;
    }

    protected void setMode(ItemStack stack, ConfiguratorMode mode) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("mode", mode.toString().toLowerCase());
        stack.m_41751_(tag);
    }

    protected void setSelectedBlock(ItemStack stack, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        if (pos == null) {
            tag.m_128473_("selected_pos");
        } else {
            tag.m_128365_("selected_pos", (Tag)ModUtils.savePosToNBT((Vec3i)pos));
        }
    }

    public static BlockPos getSelectedPos(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("selected_pos")) {
            CompoundTag pos = (CompoundTag)tag.m_128423_("selected_pos");
            return (BlockPos)ModUtils.readPosFromNBT(pos, true);
        }
        return null;
    }

    public static enum ConfiguratorMode {
        LINK_FUNCTIONAL,
        UNLINK_FUNCTIONAL,
        RESET_FUNCTIONAL,
        ROTATE;


        public String getModeMessage() {
            return "configuratormode.dawncraft." + this.toString().toLowerCase();
        }

        public TranslatableComponent getTooltip() {
            return new TranslatableComponent("tooltip.dawncraft.configuratormode." + this.toString().toLowerCase());
        }

        public static ConfiguratorMode getmode(ItemStack stack) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_("mode")) {
                return ConfiguratorMode.valueOf(tag.m_128461_("mode").toUpperCase());
            }
            return LINK_FUNCTIONAL;
        }
    }
}

