/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.dungeon.block.entity.base;

import com.afunproject.dawncraft.dungeon.block.entity.interfaces.DungeonTrigger;
import com.afunproject.dawncraft.dungeon.block.entity.interfaces.Functional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TriggerBlockEntityBase
extends BlockEntity
implements DungeonTrigger {
    protected final Set<Vec3i> linked_blocks = Sets.newHashSet();
    protected Direction direction = Direction.NORTH;

    public TriggerBlockEntityBase(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public void triggerLinkedBlocks() {
        for (Vec3i rpos : this.linked_blocks) {
            BlockPos pos = this.f_58858_.m_141952_(rpos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof Functional) || !((Functional)blockEntity).canTrigger(this)) continue;
            ((Functional)blockEntity).trigger(this);
        }
    }

    @Override
    public void removeLinkedBlock(BlockPos pos) {
        Vec3i rpos = new Vec3i(pos.m_123341_() - this.f_58858_.m_123341_(), pos.m_123342_() - this.f_58858_.m_123342_(), pos.m_123343_() - this.f_58858_.m_123343_());
        this.linked_blocks.remove(rpos);
    }

    @Override
    public void addLinkedBlock(Level level, BlockPos pos) {
        if (level == this.f_58857_) {
            Vec3i rpos = new Vec3i(pos.m_123341_() - this.f_58858_.m_123341_(), pos.m_123342_() - this.f_58858_.m_123342_(), pos.m_123343_() - this.f_58858_.m_123343_());
            this.linked_blocks.add(rpos);
        }
    }

    public void m_142466_(CompoundTag tag) {
        Direction direction;
        super.m_142466_(tag);
        if (tag.m_128441_("linked_blocks")) {
            for (Tag subTag : (ListTag)tag.m_128423_("linked_blocks")) {
                CompoundTag posTag = (CompoundTag)subTag;
                this.linked_blocks.add(new Vec3i(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z")));
            }
        }
        if (tag.m_128441_("direction") && (direction = Direction.m_122402_((String)tag.m_128461_("direction"))) != null) {
            this.direction = direction;
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (Vec3i pos : this.linked_blocks) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            list.add((Object)posTag);
        }
        tag.m_128365_("linked_blocks", (Tag)list);
        if (this.direction != null) {
            tag.m_128359_("direction", this.direction.toString());
        }
    }

    @Override
    public void rotate(Rotation rotation) {
        if (rotation == null) {
            return;
        }
        this.direction = rotation.m_55954_(this.direction);
        HashSet cache = Sets.newHashSet(this.linked_blocks);
        this.linked_blocks.clear();
        for (Vec3i pos : cache) {
            int x = pos.m_123341_();
            int z = pos.m_123343_();
            switch (rotation) {
                case CLOCKWISE_180: {
                    this.linked_blocks.add(new Vec3i(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_()));
                    break;
                }
                case CLOCKWISE_90: {
                    this.linked_blocks.add(new Vec3i(-z, pos.m_123342_(), x));
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.linked_blocks.add(new Vec3i(z, pos.m_123342_(), -x));
                    break;
                }
                case NONE: {
                    this.linked_blocks.add(pos);
                }
            }
        }
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void mirror(Mirror arg0) {
        this.direction = this.direction.m_122424_();
    }

    @Override
    public void setDirection(Direction direction) {
        Rotation rotation = null;
        if (direction == this.direction.m_122424_()) {
            rotation = Rotation.CLOCKWISE_180;
        }
        if (this.direction == Direction.NORTH && direction == Direction.EAST || this.direction == Direction.SOUTH && direction == Direction.WEST || this.direction == Direction.EAST && direction == Direction.SOUTH || this.direction == Direction.WEST && direction == Direction.NORTH) {
            rotation = Rotation.CLOCKWISE_90;
        }
        if (this.direction == Direction.NORTH && direction == Direction.WEST || this.direction == Direction.SOUTH && direction == Direction.EAST || this.direction == Direction.EAST && direction == Direction.NORTH || this.direction == Direction.WEST && direction == Direction.SOUTH) {
            rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        this.rotate(rotation);
    }
}

