/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.dungeon.block;

import com.afunproject.dawncraft.CreativeTabs;
import com.afunproject.dawncraft.dungeon.block.BlockItemDungeon;
import com.afunproject.dawncraft.dungeon.block.ChestSpawnerBlock;
import com.afunproject.dawncraft.dungeon.block.DungeonBlock;
import com.afunproject.dawncraft.dungeon.block.DungeonDoorBlock;
import com.afunproject.dawncraft.dungeon.block.RedstoneActivatorBlock;
import com.afunproject.dawncraft.dungeon.block.RedstoneTriggerBlock;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DungeonBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"dawncraft");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dawncraft");
    private static BlockBehaviour.Properties DUNGEON_PROPS = BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76373_).m_60913_(-1.0f, 1.8E7f);
    public static final DungeonBlock FOREST_BRICK = new DungeonBlock("forest_brick", MaterialColor.f_76370_, ITEMS, BLOCKS);
    public static final DungeonBlock FIRE_BRICK = new DungeonBlock("fire_brick", MaterialColor.f_76376_, ITEMS, BLOCKS);
    public static final DungeonBlock CORAL = new DungeonBlock("coral", MaterialColor.f_76395_, ITEMS, BLOCKS);
    public static final DungeonBlock MAGMA_SLATE = new DungeonBlock("magma_slate", MaterialColor.f_76373_, ITEMS, BLOCKS);
    public static final DungeonBlock MOSS_BRICK = new DungeonBlock("moss_brick", MaterialColor.f_76409_, ITEMS, BLOCKS);
    public static final DungeonBlock MUD_BRICK = new DungeonBlock("mud_brick", MaterialColor.f_76408_, ITEMS, BLOCKS);
    public static final DungeonBlock ROCK = new DungeonBlock("rock", MaterialColor.f_76373_, ITEMS, BLOCKS);
    public static final DungeonBlock SAND_BRICK = new DungeonBlock("sand_brick", MaterialColor.f_76413_, ITEMS, BLOCKS);
    public static final DungeonBlock SAND_SLATE = new DungeonBlock("sand_slate", MaterialColor.f_76413_, ITEMS, BLOCKS);
    public static final DungeonBlock SHADOW_BRICK = new DungeonBlock("shadow_brick", MaterialColor.f_76375_, ITEMS, BLOCKS);
    public static final DungeonBlock WATER_BRICK = new DungeonBlock("water_brick", MaterialColor.f_76421_, ITEMS, BLOCKS);
    public static final DungeonBlock MOSS_SLATE = new DungeonBlock("moss_slate", MaterialColor.f_76411_, ITEMS, BLOCKS);
    public static final RegistryObject<Block> FIRE_DOOR = DungeonBlocks.registerDoor("fire_door");
    public static final RegistryObject<Block> RUST_DOOR = DungeonBlocks.registerDoor("rust_door");
    public static final RegistryObject<Block> SAND_DOOR = DungeonBlocks.registerDoor("sand_door");
    public static final RegistryObject<Block> STONE_DOOR = DungeonBlocks.registerDoor("stone_door");
    public static final RegistryObject<Block> WOOD_DOOR = DungeonBlocks.registerDoor("wood_door");
    public static final RegistryObject<Block> CHEST_SPAWNER = DungeonBlocks.register("chest_spawner", ChestSpawnerBlock::new, true);
    public static final RegistryObject<Block> REDSTONE_ACTIVATOR = DungeonBlocks.register("redstone_activator", RedstoneActivatorBlock::new, true);
    public static final RegistryObject<Block> REDSTONE_TRIGGER = DungeonBlocks.register("redstone_trigger", RedstoneTriggerBlock::new, true);

    private static RegistryObject<Block> registerDoor(String name) {
        return DungeonBlocks.register(name, () -> new DungeonDoorBlock(DUNGEON_PROPS), true);
    }

    private static RegistryObject<Block> register(String name, Supplier<Block> supplier, boolean isFunctional) {
        RegistryObject block = BLOCKS.register(name, supplier);
        ITEMS.register(block.getId().m_135815_(), () -> new BlockItemDungeon((Block)block.get(), name, isFunctional ? CreativeTabs.DUNGEON_FUNCTIONAL_BLOCKS : CreativeTabs.DUNGEON_BLOCKS));
        return block;
    }
}

