/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.client.render.blockentity;

import com.afunproject.dawncraft.dungeon.KeyColour;
import com.afunproject.dawncraft.dungeon.block.DungeonDoorBlock;
import com.afunproject.dawncraft.dungeon.block.entity.DungeonDoorBlockEntity;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DungeonDoorBlockEntityRenderer
implements BlockEntityRenderer<DungeonDoorBlockEntity> {
    public DungeonDoorBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(DungeonDoorBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int combinedOverlay) {
        KeyColour colour = entity.getLockColour();
        if (colour != null) {
            Direction.Axis axis = (Direction.Axis)entity.m_58900_().m_61143_(DungeonDoorBlock.AXIS);
            ItemStack stack = new ItemStack((ItemLike)DungeonItems.getLock(colour));
            if (axis == Direction.Axis.X) {
                this.renderItem(stack, partialTicks, poseStack, buffer, light, 0.3, 0.5, 0.5, axis);
                this.renderItem(stack, partialTicks, poseStack, buffer, light, 0.7, 0.5, 0.5, axis);
            } else {
                this.renderItem(stack, partialTicks, poseStack, buffer, light, 0.5, 0.5, 0.3, axis);
                this.renderItem(stack, partialTicks, poseStack, buffer, light, 0.5, 0.5, 0.7, axis);
            }
        }
    }

    private void renderItem(ItemStack stack, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, double x, double y, double z, Direction.Axis axis) {
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        if (axis == Direction.Axis.X) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, light, OverlayTexture.f_118083_, poseStack, buffer, 0);
        poseStack.m_85849_();
    }
}

