/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MinimapRenderer {
    public static void renderBasicMinimap(PoseStack poseStack, ItemStack map, boolean fullscreen) {
        Minecraft mc = Minecraft.m_91087_();
        float scale = fullscreen ? 1.5f : 0.5f;
        float offsetX = fullscreen ? (float)mc.m_91268_().m_85445_() / 2.0f / scale - 64.0f : 12.0f;
        float offsetY = fullscreen ? (float)mc.m_91268_().m_85446_() / 2.0f / scale - 64.0f : 12.0f;
        int id = MapItem.m_151131_((ItemStack)map);
        MapItemSavedData mapdata = MapItem.m_151128_((Integer)id, (Level)mc.f_91073_);
        GlStateManager.m_84525_();
        GlStateManager.m_84335_((int)GlStateManager.SourceFactor.SRC_ALPHA.f_84751_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.f_84646_, (int)GlStateManager.SourceFactor.ONE.f_84751_, (int)GlStateManager.DestFactor.ZERO.f_84646_);
        MinimapRenderer.renderMapBackground(poseStack, mapdata == null, scale, offsetX, offsetY);
        if (mapdata != null) {
            MinimapRenderer.renderVanillaMapBlocks(poseStack, id, mapdata, scale, offsetX, offsetY);
            MinimapRenderer.renderMapDecorations(poseStack, mapdata, scale, offsetX, offsetY);
            GlStateManager.m_84519_();
        }
    }

    private static void renderMapBackground(PoseStack poseStack, boolean hasData, float scale, float offsetX, float offsetY) {
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 0.5f);
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        VertexConsumer bg_vertices = buffers.m_6299_(hasData ? ItemInHandRenderer.f_109297_ : ItemInHandRenderer.f_109298_);
        Matrix4f bg = poseStack.m_85850_().m_85861_();
        bg_vertices.m_85982_(bg, offsetX - 7.0f, offsetY + 135.0f, -1.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(255).m_5752_();
        bg_vertices.m_85982_(bg, offsetX + 135.0f, offsetY + 135.0f, -1.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(255).m_5752_();
        bg_vertices.m_85982_(bg, offsetX + 135.0f, offsetY - 7.0f, -1.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(255).m_5752_();
        bg_vertices.m_85982_(bg, offsetX - 7.0f, offsetY - 7.0f, -1.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(255).m_5752_();
        poseStack.m_85849_();
    }

    private static void renderVanillaMapBlocks(PoseStack poseStack, int mapId, MapItemSavedData mapData, float scale, float offsetX, float offsetY) {
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 0.5f);
        poseStack.m_85837_((double)offsetX, (double)offsetY, 0.0);
        MapRenderer.MapInstance instance = mc.f_91063_.m_109151_().m_168778_(mapId, mapData);
        if (instance.f_182565_) {
            instance.m_93290_();
            instance.f_182565_ = false;
        }
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        VertexConsumer vertexconsumer = buffers.m_6299_(instance.f_93282_);
        vertexconsumer.m_85982_(matrix4f, 0.0f, 128.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(255).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 128.0f, 128.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(255).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 128.0f, 0.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(255).m_5752_();
        vertexconsumer.m_85982_(matrix4f, 0.0f, 0.0f, -0.01f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(255).m_5752_();
        poseStack.m_85849_();
    }

    private static void renderMapDecorations(PoseStack poseStack, MapItemSavedData mapData, float scale, float offsetX, float offsetY) {
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        int k = 0;
        for (MapDecoration mapdecoration : mapData.m_164811_()) {
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, 0.5f);
            poseStack.m_85837_((double)offsetX, (double)offsetY, (double)(k + 2));
            if (mapdecoration.render(k)) {
                ++k;
                poseStack.m_85849_();
                continue;
            }
            poseStack.m_85837_((double)(0.0f + (float)mapdecoration.m_77804_() / 2.0f + 64.0f), (double)(0.0f + (float)mapdecoration.m_77805_() / 2.0f + 64.0f), 0.0);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(mapdecoration.m_77806_() * 360) / 16.0f));
            poseStack.m_85841_(8.0f, 8.0f, 3.0f);
            poseStack.m_85837_(-0.125, 0.125, 0.0);
            byte b0 = mapdecoration.m_77802_();
            float f1 = (float)(b0 % 16 + 0) / 16.0f;
            float f2 = (float)(b0 / 16 + 0) / 16.0f;
            float f3 = (float)(b0 % 16 + 1) / 16.0f;
            float f4 = (float)(b0 / 16 + 1) / 16.0f;
            Matrix4f matrix4f1 = poseStack.m_85850_().m_85861_();
            VertexConsumer vertexconsumer1 = buffers.m_6299_(MapRenderer.f_93254_);
            vertexconsumer1.m_85982_(matrix4f1, -1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(f1, f2).m_85969_(255).m_5752_();
            vertexconsumer1.m_85982_(matrix4f1, 1.0f, 1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(f3, f2).m_85969_(255).m_5752_();
            vertexconsumer1.m_85982_(matrix4f1, 1.0f, -1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(f3, f4).m_85969_(255).m_5752_();
            vertexconsumer1.m_85982_(matrix4f1, -1.0f, -1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(f1, f4).m_85969_(255).m_5752_();
            poseStack.m_85849_();
            if (mapdecoration.m_77810_() != null) {
                Font font = mc.f_91062_;
                Component component = mapdecoration.m_77810_();
                float f6 = font.m_92852_((FormattedText)component);
                float f7 = Mth.m_14036_((float)(25.0f / f6), (float)0.0f, (float)0.6666667f);
                poseStack.m_85836_();
                poseStack.m_85837_((double)(0.0f + (float)mapdecoration.m_77804_() / 2.0f + 64.0f - f6 * f7 / 2.0f), (double)(0.0f + (float)mapdecoration.m_77805_() / 2.0f + 64.0f + 4.0f), (double)(k + 2));
                poseStack.m_85841_(f7, f7, 1.0f);
                font.m_92841_(component, 0.0f, 0.0f, -1, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffers, false, Integer.MIN_VALUE, 255);
                poseStack.m_85849_();
            }
            ++k;
        }
    }
}

