/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.client;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.client.MinimapRenderer;
import com.afunproject.dawncraft.client.entity.FrogRenderer;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import com.afunproject.dawncraft.effects.DawnCraftEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dawncraft", value={Dist.CLIENT})
public class ClientEventListener {
    public static final TagKey<Item> MASK_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)Constants.loc("masks"));

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderLivingEventStart(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (event.getRenderer() instanceof FrogRenderer) {
            event.setCanceled(true);
        } else if (entity.m_21023_((MobEffect)DawnCraftEffects.FROGFORM.get())) {
            event.setCanceled(true);
            float pt = event.getPartialTick();
            FrogRenderer.INSTANCE.m_7392_(entity, Mth.m_14179_((float)pt, (float)entity.f_19859_, (float)entity.m_146908_()), pt, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void renderLivingEventEnd(RenderLivingEvent.Pre<?, ?> event) {
        if (event.getRenderer() instanceof FrogRenderer) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderHandEventStart(RenderHandEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_21023_((MobEffect)DawnCraftEffects.FROGFORM.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getType() == RenderGameOverlayEvent.ElementType.LAYER) {
            PoseStack poseStack = event.getMatrixStack();
            poseStack.m_85836_();
            poseStack.m_85851_();
            poseStack.m_85849_();
            LocalPlayer player = mc.f_91074_;
            if (mc.f_91066_.f_92063_ || player.m_6117_()) {
                return;
            }
            ItemStack stack = null;
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == Items.f_42573_) {
                stack = player.m_21120_(InteractionHand.MAIN_HAND);
            } else if (player.m_21120_(InteractionHand.OFF_HAND).m_41720_() == Items.f_42573_) {
                stack = player.m_21120_(InteractionHand.OFF_HAND);
            }
            if (stack != null) {
                boolean fullscreen;
                boolean bl = fullscreen = player.m_21211_().m_41619_() && mc.f_91066_.f_92095_.m_90857_();
                if (fullscreen) {
                    event.setCanceled(true);
                    if (!mc.f_91066_.m_92176_().m_90612_()) {
                        mc.f_91066_.m_92157_(CameraType.FIRST_PERSON);
                    }
                }
                MinimapRenderer.renderBasicMinimap(poseStack, stack, player.m_21211_().m_41619_() && mc.f_91066_.f_92095_.m_90857_());
            }
        }
    }

    @SubscribeEvent
    public void renderCamera(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player.m_21023_((MobEffect)DawnCraftEffects.TREMOR.get())) {
            float a = (float)(player.m_21124_((MobEffect)DawnCraftEffects.TREMOR.get()).m_19564_() + 1) * 0.5f;
            float t = (mc.m_91296_() + (float)player.f_19797_) * a * 0.75f;
            event.setPitch((float)((double)event.getPitch() + (double)a * Math.sin(2.0f * t + 3.0f)));
            event.setYaw((float)((double)event.getYaw() + (double)a * Math.cos(t)));
            event.setRoll((float)((double)event.getRoll() + (double)a * Math.sin(5.0f - t * 3.0f)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void mouseScrollInput(InputEvent.MouseScrollEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && player.m_21023_((MobEffect)DawnCraftEffects.IMMOBILIZED.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void addTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_204117_(MASK_TAG) && stack.m_41720_() != DungeonItems.CURSED_MASK.get()) {
            event.getToolTip().add(new TranslatableComponent("tooltip.dawncraft.mask").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131157_(ChatFormatting.DARK_PURPLE)));
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null && player.m_21023_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()) && player.f_19797_ % Math.floorDiv(10, player.m_21124_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()).m_19564_() + 1) == 0) {
                mc.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, player.m_20208_(0.5), player.m_20187_(), player.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
    }
}

