/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.capability;

import com.afunproject.dawncraft.capability.CapabilitiesRegister;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface SpawnTracker {
    public boolean hasSpawned();

    public void setSpawned();

    public void readNBT(CompoundTag var1);

    public CompoundTag writeNBT(CompoundTag var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final SpawnTracker impl = new Implementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == CapabilitiesRegister.SPAWN_TRACKER ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.writeNBT(new CompoundTag());
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.readNBT(nbt);
        }
    }

    public static class Implementation
    implements SpawnTracker {
        private boolean has_spawned;

        @Override
        public boolean hasSpawned() {
            return this.has_spawned;
        }

        @Override
        public void setSpawned() {
            this.has_spawned = true;
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            if (nbt.m_128441_("has_spawned")) {
                this.has_spawned = nbt.m_128471_("has_spawned");
            }
        }

        @Override
        public CompoundTag writeNBT(CompoundTag nbt) {
            if (this.has_spawned) {
                nbt.m_128379_("has_spawned", this.has_spawned);
            }
            return nbt;
        }
    }
}

