/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.capability;

import com.afunproject.dawncraft.capability.CapabilitiesRegister;
import com.afunproject.dawncraft.invasion.InvasionEntry;
import com.afunproject.dawncraft.invasion.InvasionRegistry;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface Invasions {
    public void tryToSpawnInvasion(Player var1);

    public void setNextSpawn(int var1);

    public CompoundTag save();

    public void load(CompoundTag var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        protected Invasions impl = new Implementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
            return cap == CapabilitiesRegister.INVASIONS ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.save();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.load(nbt);
        }
    }

    public static class Implementation
    implements Invasions {
        private Random rand = new Random();
        private List<InvasionEntry> invasions = Lists.newArrayList();
        private int nextSpawn = -1;

        public Implementation() {
            this.invasions.addAll(InvasionRegistry.getInvasions());
        }

        @Override
        public void tryToSpawnInvasion(Player player) {
            if (this.nextSpawn == -1 || player.f_19853_.f_46443_ || this.invasions.isEmpty()) {
                return;
            }
            if (!player.f_19853_.m_46472_().m_135782_().equals((Object)new ResourceLocation("overworld"))) {
                return;
            }
            if (this.nextSpawn-- == 0) {
                if (this.rand.nextInt(3) > 0) {
                    InvasionEntry invasion = this.invasions.get(this.rand.nextInt(this.invasions.size()));
                    invasion.spawnEntities(player);
                    this.invasions.remove(invasion);
                }
                this.nextSpawn = this.rand.nextInt(72000, 96000);
            }
        }

        @Override
        public void setNextSpawn(int ticks) {
            this.nextSpawn = ticks;
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (InvasionEntry invasion : this.invasions) {
                list.add((Object)invasion.save());
            }
            tag.m_128365_("invasions", (Tag)list);
            tag.m_128405_("nextSpawn", this.nextSpawn);
            return tag;
        }

        @Override
        public void load(CompoundTag tag) {
            this.invasions.clear();
            for (Tag invasion : tag.m_128437_("invasions", 10)) {
                try {
                    this.invasions.add(new InvasionEntry((CompoundTag)invasion));
                }
                catch (Exception exception) {}
            }
            if (tag.m_128441_("nextSpawn")) {
                this.nextSpawn = tag.m_128451_("nextSpawn");
            }
        }
    }
}

