/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.capability;

import com.afunproject.dawncraft.Constants;
import com.afunproject.dawncraft.capability.FollowQuest;
import com.afunproject.dawncraft.capability.Invasions;
import com.afunproject.dawncraft.capability.QuestProvider;
import com.afunproject.dawncraft.capability.RestrictBlock;
import com.afunproject.dawncraft.capability.SageQuestTracker;
import com.afunproject.dawncraft.capability.SpawnTracker;
import com.afunproject.dawncraft.integration.quests.custom.QuestEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

public class CapabilitiesRegister {
    private static EntityType<?>[] QUEST_ENTITIES = new EntityType[0];
    public static Capability<FollowQuest> FOLLOW_QUEST = CapabilityManager.get((CapabilityToken)new CapabilityToken<FollowQuest>(){});
    public static Capability<RestrictBlock> RESTRICT_BLOCK = CapabilityManager.get((CapabilityToken)new CapabilityToken<RestrictBlock>(){});
    public static Capability<Invasions> INVASIONS = CapabilityManager.get((CapabilityToken)new CapabilityToken<Invasions>(){});
    public static Capability<QuestEntity> QUEST_ENTITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<QuestEntity>(){});
    public static Capability<SpawnTracker> SPAWN_TRACKER = CapabilityManager.get((CapabilityToken)new CapabilityToken<SpawnTracker>(){});
    public static Capability<SageQuestTracker> SAGE_QUEST_TRACKER = CapabilityManager.get((CapabilityToken)new CapabilityToken<SageQuestTracker>(){});

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(FollowQuest.class);
        event.register(RestrictBlock.class);
        event.register(Invasions.class);
        event.register(QuestEntity.class);
    }

    @SubscribeEvent
    public void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Mob) {
            event.addCapability(Constants.loc("follow_quest"), (ICapabilityProvider)new FollowQuest.Provider());
        }
        if (entity instanceof PathfinderMob) {
            event.addCapability(Constants.loc("restrict_block"), (ICapabilityProvider)new RestrictBlock.Provider());
        }
        if (entity instanceof Player) {
            event.addCapability(Constants.loc("invasions"), (ICapabilityProvider)new Invasions.Provider());
        }
        if (ArrayUtils.contains((Object[])QUEST_ENTITIES, (Object)entity.m_6095_())) {
            event.addCapability(Constants.loc("quest"), (ICapabilityProvider)new QuestProvider());
        }
        if (entity instanceof Mob || entity instanceof Player) {
            event.addCapability(Constants.loc("spawn_tracker"), (ICapabilityProvider)new SpawnTracker.Provider());
        }
        if (entity instanceof Player) {
            event.addCapability(Constants.loc("sage_quest"), (ICapabilityProvider)new SageQuestTracker.Provider());
        }
    }
}

