/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft;

import com.afunproject.dawncraft.capability.CapabilitiesRegister;
import com.afunproject.dawncraft.capability.Invasions;
import com.afunproject.dawncraft.capability.RestrictBlock;
import com.afunproject.dawncraft.capability.SageQuestTracker;
import com.afunproject.dawncraft.dungeon.item.DungeonItems;
import com.afunproject.dawncraft.dungeon.item.RebirthStaffItem;
import com.afunproject.dawncraft.effects.DawnCraftEffects;
import com.afunproject.dawncraft.integration.apotheosis.ApotheosisCompat;
import com.afunproject.dawncraft.integration.epicfight.EpicFightCompat;
import com.afunproject.dawncraft.integration.suplementaries.RitualChecker;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dawncraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventListener {
    private static final UUID BOSS_MODIFIER = UUID.fromString("dd686c7a-e2c7-479c-96d5-3e193b35c7b8");
    public static final List<Consumer<EntityAttributeCreationEvent>> ATTRIBUTE_SUPPLIERS = Lists.newArrayList();
    List<String> bosses = Lists.newArrayList((Object[])new String[]{"entity.minecraft.ender_dragon", "entity.minecraft.wither", "entity.simple_mobs.ogre", "entity.simple_mobs.martian", "entity.simple_mobs.sentinel_knight", "entity.simple_mobs.fire_giant", "entity.simple_mobs.nine_tails", "entity.simple_mobs.skeletonlord", "entity.simple_mobs.knight_4", "entity.simple_mobs.fire_dragon", "entity.simple_mobs.ice_dragon", "entity.simple_mobs.notch", "entity.simple_mobs.elemental_deity", "entity.bloodandmadness.father_gascoigne", "entity.bloodandmadness.gascoigne_beast", "entity.bloodandmadness.micolash", "entity.ob_aquamirae.captain_cornelia", "entity.conjurer_illager.conjurer", "entity.mowziesmobs.ferrous_wroughtnaut", "entity.mowziesmobs.barako", "entity.mowziesmobs.frostmaw", "entity.mowziesmobs.naga", "entity.meetyourfight.projectile_line", "entity.meetyourfight.swamp_mine", "entity.meetyourfight.swampjaw", "entity.meetyourfight.dame_fortuna", "entity.meetyourfight.bellringer", "entity.alexsmobs.warped_mosco", "entity.alexsmobs.void_worm", "entity.cataclysm.ender_golem", "entity.cataclysm.netherite_monstrosity", "entity.ba_bt.land_golem", "entity.ba_bt.ocean_golem", "entity.ba_bt.core_golem", "entity.a_bt.nether_golem", "entity.ba_bt.end_golem", "entity.ba_bt.sky_golem", "entity.goblinsanddungeons.goblin_king", "entity.illageandspillage.magispeller", "entity.illageandspillage.illashooter", "entity.illageandspillage.twittollager", "entity.illageandspillage.spiritcaller"});

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        LazyOptional optional;
        Player player = event.player;
        if (event.phase == TickEvent.Phase.END && player != null && !(player instanceof FakePlayer) && !player.f_19853_.f_46443_ && (optional = player.getCapability(CapabilitiesRegister.INVASIONS)).isPresent()) {
            ((Invasions)optional.resolve().get()).tryToSpawnInvasion(player);
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        IronGolem golem;
        RestrictBlock cap;
        PathfinderMob entity;
        LazyOptional optional;
        if (this.bosses.contains(event.getEntity().m_6095_().m_20675_()) && event.getEntity() instanceof Mob) {
            Mob boss = (Mob)event.getEntity();
            int players = 0;
            for (Player player : boss.f_19853_.m_6907_()) {
                if (!(player.m_20270_((Entity)boss) <= 100.0f)) continue;
                ++players;
            }
            if (players > 1) {
                double damage_multiplier = Math.max(1.5, Math.pow(1.05, players - 1));
                AttributeInstance damage = boss.m_21051_(Attributes.f_22281_);
                damage.m_22120_(BOSS_MODIFIER);
                damage.m_22125_(new AttributeModifier(BOSS_MODIFIER, "dawncraft_multiplayer_scaling", damage_multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
                double health_multiplier = Math.max(2.0, Math.pow(1.25, players - 1));
                AttributeInstance health = boss.m_21051_(Attributes.f_22276_);
                health.m_22120_(BOSS_MODIFIER);
                health.m_22125_(new AttributeModifier(BOSS_MODIFIER, "dawncraft_multiplayer_scaling", health_multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
        if (event.getEntity() instanceof PathfinderMob && (optional = (entity = (PathfinderMob)event.getEntity()).getCapability(CapabilitiesRegister.RESTRICT_BLOCK)).isPresent() && (cap = (RestrictBlock)optional.resolve().get()).canRestrict((Mob)entity)) {
            entity.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal(entity, 1.0));
            cap.applyRestriction((Mob)entity);
        }
        if (event.getEntity() instanceof IronGolem && !(golem = (IronGolem)event.getEntity()).m_28876_()) {
            golem.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 10000000, 0, false, false));
            golem.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 10000000, 0, false, false));
            golem.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 10000000, 0, false, false));
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            if (!player.m_150110_().f_35938_) {
                player.m_143403_(GameType.SURVIVAL);
            }
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player player = event.getPlayer();
        original.reviveCaps();
        LazyOptional optionalOld = original.getCapability(CapabilitiesRegister.SAGE_QUEST_TRACKER);
        LazyOptional optional = player.getCapability(CapabilitiesRegister.SAGE_QUEST_TRACKER);
        if (optionalOld.isPresent() && optional.isPresent()) {
            ((SageQuestTracker)optional.resolve().get()).readNBT(((SageQuestTracker)optionalOld.resolve().get()).writeNBT());
        }
        if (original.m_21023_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get())) {
            player.m_7292_(new MobEffectInstance((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get(), 3600, Math.min(4, original.m_21124_((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get()).m_19564_() + 1), true, true));
        } else {
            player.m_7292_(new MobEffectInstance((MobEffect)DawnCraftEffects.FRACTURED_SOUL.get(), 3600, 0, true, true));
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        if (!level.f_46443_) {
            ItemStack stack = event.getItemStack();
            BlockPos pos = event.getPos();
            BlockState state = level.m_8055_(pos);
            if (stack != null && state != null && state.m_60713_(Blocks.f_50201_) && stack.m_150930_((Item)DungeonItems.REBIRTH_STAFF.get()) && !RebirthStaffItem.isPowered(stack) && ModList.get().isLoaded("supplementaries") && RitualChecker.isValid(level, pos)) {
                RitualChecker.startRitual(stack, level, pos);
                event.setCanceled(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void livingHurt(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity.f_19853_.f_46443_ || !(source.m_7639_() instanceof LivingEntity)) return;
        LivingEntity attacker = (LivingEntity)source.m_7639_();
        if (attacker.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)DungeonItems.SLAYERS_BLADE.get())) {
            if (attacker instanceof Player) {
                if (!ModList.get().isLoaded("epicfight") || !EpicFightCompat.isCombatMode((Player)attacker)) return;
                event.setAmount(entity.m_21233_() * 0.1f);
                return;
            }
            event.setAmount(entity.m_21233_() * 0.1f);
            return;
        }
        if (!attacker.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)DungeonItems.EXECUTIONER.get()) || !((double)entity.m_21223_() < (double)entity.m_21233_() * 0.15)) return;
        attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_11860_, SoundSource.PLAYERS, 1.0f, attacker.m_21187_().nextFloat());
        event.setAmount(entity.m_21223_());
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        LivingEntity boss;
        DamageSource source;
        if (event.getEntity() instanceof Player & !event.getEntity().f_19853_.f_46443_ && (source = event.getSource()).m_7639_() instanceof LivingEntity && this.bosses.contains((boss = (LivingEntity)source.m_7639_()).m_6095_().m_20675_())) {
            boss.m_5634_(boss.m_21233_() * 0.25f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void livingDeathEnd(LivingDeathEvent event) {
        Level level = event.getEntity().f_19853_;
        if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46133_) && ModList.get().isLoaded("apotheosis")) {
            ApotheosisCompat.fixNBT(event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        for (Consumer<EntityAttributeCreationEvent> supplier : ATTRIBUTE_SUPPLIERS) {
            supplier.accept(event);
        }
    }
}

