/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.feature;

import insane96mcp.enhancedai.modules.zombie.ai.FishingTargetGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import java.util.Collections;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Fisher Zombie", description="Let zombies use Fishing Rods, reeling players in. Either put a Fishing Rod in main or off hand and when near enough from the player they will throw it.")
public class FisherZombie
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> equipFishingRodChanceConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public double equipFishingRodChance = 0.07;
    public Blacklist entityBlacklist;

    public FisherZombie(Module module) {
        super(Config.builder, module);
        Config.builder.comment(this.getDescription()).push(this.getName());
        this.equipFishingRodChanceConfig = Config.builder.comment("Chance for a Zombie to spawn with a Fishing Rod in the off hand. I highly recommend using something like Mobs Properties Randomness to have more control over mobs equipment.").defineInRange("Equip Fishing Rod Chance", this.equipFishingRodChance, 0.0, 1.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the Fisher AI").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.equipFishingRodChance = (Double)this.equipFishingRodChanceConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        Zombie zombie;
        Entity entity;
        if (!this.isEnabled() || event.getWorld().f_46443_ || !((entity = event.getEntity()) instanceof Zombie) || this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(zombie = (Zombie)entity))) {
            return;
        }
        if (event.getWorld().f_46441_.nextDouble() < this.equipFishingRodChance) {
            zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42523_));
        }
        zombie.f_21345_.m_25352_(2, (Goal)new FishingTargetGoal(zombie));
    }
}

