/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.zombie.feature;

import insane96mcp.enhancedai.modules.zombie.ai.DiggingGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Digger Zombie", description="Zombies can mine blocks to reach the target. Uses offhand item to mine")
public class DiggerZombie
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> diggerChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> diggerToolOnlyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> diggerProperToolOnlyConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> equipWoodenPickConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxYDigConfig;
    private final ForgeConfigSpec.ConfigValue<Integer> maxDistanceConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> blacklistTileEntitiesConfig;
    private final ForgeConfigSpec.ConfigValue<Double> miningSpeedMultiplierConfig;
    private final Blacklist.Config blockBlacklistConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public double diggerChance = 0.07;
    public boolean diggerToolOnly = false;
    public boolean diggerProperToolOnly = false;
    public boolean equipWoodenPick = true;
    public int maxYDig = 64;
    public int maxDistance = 0;
    public boolean blacklistTileEntities = false;
    public double miningSpeedMultiplier = 1.0;
    public Blacklist blockBlacklist;
    public Blacklist entityBlacklist;

    public DiggerZombie(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.diggerChanceConfig = Config.builder.comment("Chance for a Zombie to spawn with the digger ability").defineInRange("Digger Chance", this.diggerChance, 0.0, 1.0);
        this.diggerToolOnlyConfig = Config.builder.comment("Zombies with Digger AI will mine only if they have any tool in the off-hand").define("Digger Tool Only", this.diggerToolOnly);
        this.diggerProperToolOnlyConfig = Config.builder.comment("Zombies with Digger AI will mine only if their off-hand tool can mine targeted blocks (e.g. zombies with shovels will not mine stone). Blocks that require no tool (e.g. planks) will be minable regardless of proper tool or not.").define("Digger Proper Tool Only", this.diggerProperToolOnly);
        this.equipWoodenPickConfig = Config.builder.comment("Zombies with Digger AI will spawn with a Wooden Pickaxe.").define("Equip Wooden Pick", this.equipWoodenPick);
        this.maxYDigConfig = Config.builder.comment("The maximum Y coordinate at which Zombies can mine.").defineInRange("Max Y Dig", this.maxYDig, -128, 512);
        this.maxDistanceConfig = Config.builder.comment("The maximum distance from the target at which the zombie can mine. Set to 0 to always mine.").defineInRange("Max Distance", this.maxDistance, 0, 128);
        this.miningSpeedMultiplierConfig = Config.builder.comment("Multiplier for digger zombies mining speed. E.g. with this set to 2, zombies will take twice the time to mine a block.").defineInRange("Digger Speed Multiplier", this.miningSpeedMultiplier, 0.0, 128.0);
        this.blacklistTileEntitiesConfig = Config.builder.comment("Zombies with Digger AI will not be able to break tile entities").define("Blacklist Tile Entities", this.blacklistTileEntities);
        this.blockBlacklistConfig = new Blacklist.Config(Config.builder, "Block Blacklist", "Blocks in here will not be minable by zombies (or will be the only minable in case it's whitelist)").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the Digger AI").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.diggerChance = (Double)this.diggerChanceConfig.get();
        this.diggerToolOnly = (Boolean)this.diggerToolOnlyConfig.get();
        this.diggerProperToolOnly = (Boolean)this.diggerProperToolOnlyConfig.get();
        this.equipWoodenPick = (Boolean)this.equipWoodenPickConfig.get();
        this.maxYDig = (Integer)this.maxYDigConfig.get();
        this.maxDistance = (Integer)this.maxDistanceConfig.get();
        this.miningSpeedMultiplier = (Double)this.miningSpeedMultiplierConfig.get();
        this.blacklistTileEntities = (Boolean)this.blacklistTileEntitiesConfig.get();
        this.blockBlacklist = this.blockBlacklistConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        Zombie zombie;
        Entity entity;
        if (!this.isEnabled() || event.getWorld().f_46443_ || !((entity = event.getEntity()) instanceof Zombie) || this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(zombie = (Zombie)entity))) {
            return;
        }
        CompoundTag persistentData = zombie.getPersistentData();
        boolean miner = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:miner", zombie.f_19853_.f_46441_.nextDouble() < this.diggerChance);
        boolean diggerToolOnly = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:tool_only", this.diggerToolOnly);
        boolean diggerProperToolOnly = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:proper_tool_only", this.diggerProperToolOnly);
        if (miner) {
            zombie.f_21345_.m_25352_(1, (Goal)new DiggingGoal(zombie, this.maxDistance, diggerToolOnly, diggerProperToolOnly));
            if (this.equipWoodenPick) {
                zombie.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42422_));
                zombie.m_21409_(EquipmentSlot.OFFHAND, -1.0f);
            }
        }
    }
}

