/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.witch.feature;

import insane96mcp.enhancedai.modules.witch.ai.DarkArtWitchGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Witch;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Dark Arts Witches", description="Witches summon Villagers and cast a lightning bolt upon them.")
public class DarkArtWitch
extends Feature {
    private final ForgeConfigSpec.DoubleValue darkArtChanceConfig;
    public double darkArtChance = 0.333;

    public DarkArtWitch(Module module) {
        super(Config.builder, module);
        super.pushConfig(Config.builder);
        this.darkArtChanceConfig = Config.builder.comment("Chance for a witch to get the Dark Art AI (as soon as they have a target and are less than 10 blocks away from the target will summon a Villager and cast a lightning bolt on them").defineInRange("Dark Art Chance", this.darkArtChance, 0.0, 1.0);
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.darkArtChance = (Double)this.darkArtChanceConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getWorld().f_46443_ || !((entity = event.getEntity()) instanceof Witch)) {
            return;
        }
        Witch witch = (Witch)entity;
        CompoundTag persistentData = witch.getPersistentData();
        boolean darkArt = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:dark_arts", witch.f_19853_.f_46441_.nextDouble() < this.darkArtChance);
        if (!darkArt) {
            return;
        }
        DarkArtWitchGoal darkArtWitchGoal = new DarkArtWitchGoal(witch);
        witch.f_21345_.m_25352_(1, (Goal)darkArtWitchGoal);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        Entity entity;
        if (!this.isEnabled() || event.getEntity().f_19853_.f_46443_ || !((entity = event.getEntity()) instanceof Witch)) {
            return;
        }
        Witch witch = (Witch)entity;
        witch.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            DarkArtWitchGoal goal;
            Goal patt2819$temp = prioritizedGoal.m_26015_();
            if (patt2819$temp instanceof DarkArtWitchGoal && (goal = (DarkArtWitchGoal)patt2819$temp).isRunning()) {
                goal.forceStop();
            }
        });
    }
}

