/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.villager.feature;

import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Villager Attacking", description="Make villagers fight back")
public class VillagerAttacking
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Boolean> villagersFightBackConfig;
    private final ForgeConfigSpec.ConfigValue<Double> speedMultiplierConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public boolean villagersFightBack = true;
    public double speedMultiplier = 0.8;
    public Blacklist entityBlacklist;
    private static final double BASE_ATTACK_DAMAGE = 4.0;

    public VillagerAttacking(Module module) {
        super(Config.builder, module, true, false);
        this.pushConfig(Config.builder);
        this.villagersFightBackConfig = Config.builder.comment("If true, when attacked, villagers will call other villagers for help and attack back. Attack damage can't be changed via config due to limitation so use mods like Mobs Properties Randomness to increase the damage. Base damage is " + String.format("%.1f", 4.0)).define("Villagers Fight back", this.villagersFightBack);
        this.speedMultiplierConfig = Config.builder.comment("Movement speed multiplier when attacking.").defineInRange("Movement Speed Multiplier", this.speedMultiplier, 0.0, 4.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't be affected by this feature").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.villagersFightBack = (Boolean)this.villagersFightBackConfig.get();
        this.speedMultiplier = (Double)this.speedMultiplierConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        Villager villager;
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Villager) || this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)(villager = (Villager)entity))) {
            return;
        }
        CompoundTag persistentData = villager.getPersistentData();
        double movementSpeedMultiplier = NBTUtils.getDoubleOrPutDefault(persistentData, "enhancedai:speed_multiplier_when_aggroed", this.speedMultiplier);
        if (this.villagersFightBack) {
            villager.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)villager, new Class[0]).m_26044_(new Class[0]));
            villager.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)villager, movementSpeedMultiplier, false));
        }
    }
}

