/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.skeleton.feature;

import insane96mcp.enhancedai.modules.base.ai.EAAvoidEntityGoal;
import insane96mcp.enhancedai.modules.skeleton.ai.EARangedBowAttackGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import insane96mcp.insanelib.config.MinMax;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraftforge.common.ForgeConfigSpec;

@Label(name="Skeleton Shoot", description="Skeletons are more precise when shooting and strafing is removed, can hit a target from up to 64 blocks and try to stay away from the target.")
public class SkeletonShoot
extends Feature {
    private final MinMax.Config shootingRangeConfig;
    private final ForgeConfigSpec.ConfigValue<Double> strafeChanceConfig;
    private final ForgeConfigSpec.ConfigValue<Double> arrowInaccuracyConfig;
    private final ForgeConfigSpec.ConfigValue<Double> spammerChanceConfig;
    private final Blacklist.Config entityBlacklistConfig;
    private final List<String> defaultBlacklist = List.of("quark:forgotten");
    public MinMax shootingRange = new MinMax(24.0, 32.0);
    public double strafeChance = 0.333;
    public double arrowInaccuracy = 2.0;
    public double spammerChance = 0.07;
    public Blacklist entityBlacklist;

    public SkeletonShoot(Module module) {
        super(Config.builder, module);
        super.pushConfig(Config.builder);
        this.shootingRangeConfig = new MinMax.Config(Config.builder, "Shooting Range", "The range from where a skeleton will shoot a player").setMinMax(1.0, 64.0, this.shootingRange).build();
        this.strafeChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn with the ability to strafe (like vanilla)").defineInRange("Strafe chance", this.strafeChance, 0.0, 1.0);
        this.arrowInaccuracyConfig = Config.builder.comment("How much inaccuracy does the arrow fired by skeletons have. Vanilla skeletons have 10/6/2 inaccuracy in easy/normal/hard difficulty.").defineInRange("Arrow Inaccuracy", this.arrowInaccuracy, 0.0, 30.0);
        this.spammerChanceConfig = Config.builder.comment("Chance for a Skeleton to spawn as a spammer, which spams arrows instead of fully charging the bow").defineInRange("Spammer chance", this.spammerChance, 0.0, 1.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the enhanced Shoot AI").setDefaultList(this.defaultBlacklist).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.shootingRange = this.shootingRangeConfig.get();
        this.strafeChance = (Double)this.strafeChanceConfig.get();
        this.arrowInaccuracy = (Double)this.arrowInaccuracyConfig.get();
        this.spammerChance = (Double)this.spammerChanceConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    public void onReassessWeaponGoal(AbstractSkeleton skeleton) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)skeleton)) {
            return;
        }
        CompoundTag persistentData = skeleton.getPersistentData();
        boolean strafe = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:strafe", skeleton.f_19853_.f_46441_.nextDouble() < this.strafeChance);
        int shootingRange = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:shooting_range", this.shootingRange.getIntRandBetween(skeleton.m_21187_()));
        boolean hasAIArrowAttack = false;
        for (WrappedGoal prioritizedGoal : skeleton.f_21345_.f_25345_) {
            if (!prioritizedGoal.m_26015_().equals(skeleton.f_32130_)) continue;
            hasAIArrowAttack = true;
        }
        List<Goal> avoidEntityGoals = skeleton.f_21345_.f_25345_.stream().map(WrappedGoal::m_26015_).filter(g -> g instanceof EAAvoidEntityGoal).toList();
        avoidEntityGoals.forEach(arg_0 -> ((GoalSelector)skeleton.f_21345_).m_25363_(arg_0));
        if (hasAIArrowAttack) {
            int attackCooldown = 20;
            int bowChargeTicks = 20;
            double inaccuracy = this.arrowInaccuracy;
            if (skeleton.f_19853_.f_46441_.nextDouble() < this.spammerChance) {
                attackCooldown = 5;
                bowChargeTicks = 5;
                inaccuracy *= 2.0;
            }
            if (!skeleton.f_19853_.m_46791_().equals((Object)Difficulty.HARD)) {
                attackCooldown *= 2;
            }
            EARangedBowAttackGoal<AbstractSkeleton> EARangedBowAttackGoal2 = new EARangedBowAttackGoal<AbstractSkeleton>(skeleton, 1.0, shootingRange, strafe).setAttackCooldown(attackCooldown).setBowChargeTicks(bowChargeTicks).setInaccuracy((float)inaccuracy);
            skeleton.f_21345_.m_25352_(2, EARangedBowAttackGoal2);
        }
    }
}

