/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.ghast.feature;

import insane96mcp.enhancedai.modules.ghast.ai.GhastShootFireballGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.config.Blacklist;
import insane96mcp.insanelib.config.MinMax;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Ghast Shoot", description="Various changes to ghast shooting.")
public class GhastShoot
extends Feature {
    private final MinMax.Config attackCooldownConfig;
    private final MinMax.Config fireballsShotConfig;
    private final ForgeConfigSpec.DoubleValue shootWhenNotSeenConfig;
    private final Blacklist.Config entityBlacklistConfig;
    public MinMax attackCooldown = new MinMax(40.0, 50.0);
    public MinMax fireballsShot = new MinMax(1.0, 3.0);
    public double shootWhenNotSeen = 0.3;
    public Blacklist entityBlacklist;

    public GhastShoot(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.attackCooldownConfig = new MinMax.Config(Config.builder, "Attack Cooldown", "How many ticks pass between shooting fireballs. Vanilla is 40").setMinMax(1.0, 300.0, this.attackCooldown).build();
        this.fireballsShotConfig = new MinMax.Config(Config.builder, "Fireballs shot", "How many fireballs ghast shoot in rapid succession. Vanilla is 1").setMinMax(1.0, 16.0, this.fireballsShot).build();
        this.shootWhenNotSeenConfig = Config.builder.comment("Chance for a Ghast to try and shoot the target even if can't see it. If enabled and the Ghast can't see the target, he will shoot 4 times as fast to breach.").defineInRange("Shoot when not seen", this.shootWhenNotSeen, 0.0, 1.0);
        this.entityBlacklistConfig = new Blacklist.Config(Config.builder, "Entity Blacklist", "Entities that shouldn't get the new Ghast Fireballing AI").setDefaultList(Collections.emptyList()).setIsDefaultWhitelist(false).build();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.attackCooldown = this.attackCooldownConfig.get();
        this.fireballsShot = this.fireballsShotConfig.get();
        this.shootWhenNotSeen = (Double)this.shootWhenNotSeenConfig.get();
        this.entityBlacklist = this.entityBlacklistConfig.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Ghast)) {
            return;
        }
        Ghast ghast = (Ghast)entity;
        if (this.entityBlacklist.isEntityBlackOrNotWhitelist((Entity)ghast)) {
            return;
        }
        CompoundTag persistentData = ghast.getPersistentData();
        int attackCooldown = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:attack_cooldown", this.attackCooldown.getIntRandBetween(ghast.m_21187_()));
        int fireballsShot = NBTUtils.getIntOrPutDefault(persistentData, "enhancedai:fireballs_shot", this.fireballsShot.getIntRandBetween(ghast.m_21187_()));
        boolean shootWhenNotSeen = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:shoot_when_not_seen", ghast.m_21187_().nextDouble() < this.shootWhenNotSeen);
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        ghast.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof Ghast.GhastShootFireballGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)ghast.f_21345_).m_25363_(arg_0));
        ghast.f_21345_.m_25352_(4, (Goal)new GhastShootFireballGoal(ghast).setAttackCooldown(attackCooldown).setFireballsToShot(fireballsShot).setIgnoreLineOfSight(shootWhenNotSeen));
    }
}

