/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.enhancedai.modules.creeper.feature;

import insane96mcp.enhancedai.modules.creeper.ai.AICreeperLaunchGoal;
import insane96mcp.enhancedai.modules.creeper.ai.AICreeperSwellGoal;
import insane96mcp.enhancedai.setup.Config;
import insane96mcp.enhancedai.setup.EASounds;
import insane96mcp.enhancedai.setup.NBTUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Explosion;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Creeper Swell", description="Various changes to Creepers exploding. Ignoring Walls, Walking Fuse and smarter exploding based off explosion size")
public class CreeperSwell
extends Feature {
    private final ForgeConfigSpec.ConfigValue<Double> walkingFuseConfig;
    private final ForgeConfigSpec.ConfigValue<Double> ignoreWallsConfig;
    private final ForgeConfigSpec.ConfigValue<Double> breachConfig;
    private final ForgeConfigSpec.ConfigValue<Double> launchConfig;
    private final ForgeConfigSpec.ConfigValue<Boolean> tntLikeConfig;
    private final ForgeConfigSpec.DoubleValue cenaChanceConfig;
    private final ForgeConfigSpec.BooleanValue cenaFireConfig;
    private final ForgeConfigSpec.DoubleValue cenaExplosionPowerConfig;
    public double walkingFuseChance = 0.1;
    public double ignoreWalls = 0.1;
    public double breach = 0.075;
    public double launch = 0.05;
    public boolean tntLike = false;
    public double cenaChance = 0.02;
    public boolean cenaFire = false;
    public double cenaExplosionPower = 6.0;

    public CreeperSwell(Module module) {
        super(Config.builder, module);
        this.pushConfig(Config.builder);
        this.walkingFuseConfig = Config.builder.comment("Percentage chance for a Creeper to not stand still while exploding.").defineInRange("Walking Fuse Chance", this.walkingFuseChance, 0.0, 1.0);
        this.ignoreWallsConfig = Config.builder.comment("Percentage chance for a Creeper to ignore walls while targeting a player. This means that a creeper will be able to explode if it's in the correct range from a player even if there's a wall between.").defineInRange("Ignore Walls Chance", this.ignoreWalls, 0.0, 1.0);
        this.breachConfig = Config.builder.comment("Breaching creepers will try to open an hole in the wall to let mobs in.").defineInRange("Breach Chance", this.breach, 0.0, 1.0);
        this.launchConfig = Config.builder.comment("Launching creepers will try ignite and throw themselves at the player.").defineInRange("Launch Chance", this.launch, 0.0, 1.0);
        this.tntLikeConfig = Config.builder.comment("If true creepers will ignite if damaged by an explosion.").define("TNT Like", this.tntLike);
        Config.builder.push("Creeper Cena");
        this.cenaChanceConfig = Config.builder.comment("AND HIS NAME IS ...").defineInRange("Cena Chance", this.cenaChance, 0.0, 1.0);
        this.cenaFireConfig = Config.builder.comment("If true, Creeper Cena explosion will generate fire").define("Cena generates fire", this.cenaFire);
        this.cenaExplosionPowerConfig = Config.builder.comment("Explosion power of Creeper Cena").defineInRange("Cena explosion power", this.cenaExplosionPower, 0.0, 12.0);
        Config.builder.pop();
        Config.builder.pop();
    }

    public void loadConfig() {
        super.loadConfig();
        this.walkingFuseChance = (Double)this.walkingFuseConfig.get();
        this.ignoreWalls = (Double)this.ignoreWallsConfig.get();
        this.breach = (Double)this.breachConfig.get();
        this.launch = (Double)this.launchConfig.get();
        this.tntLike = (Boolean)this.tntLikeConfig.get();
        this.cenaChance = (Double)this.cenaChanceConfig.get();
        this.cenaFire = (Boolean)this.cenaFireConfig.get();
        this.cenaExplosionPower = (Double)this.cenaExplosionPowerConfig.get();
    }

    @SubscribeEvent
    public void explosionStartEvent(ExplosionEvent.Detonate event) {
        if (!this.isEnabled()) {
            return;
        }
        Explosion e = event.getExplosion();
        Entity entity = e.getExploder();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        if (creeper.getPersistentData().m_128471_("enhancedai:cena")) {
            creeper.m_5496_((SoundEvent)EASounds.CREEPER_CENA_EXPLODE.get(), 4.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void eventEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        ArrayList<Goal> goalsToRemove = new ArrayList<Goal>();
        creeper.f_21345_.f_25345_.forEach(prioritizedGoal -> {
            if (prioritizedGoal.m_26015_() instanceof SwellGoal) {
                goalsToRemove.add(prioritizedGoal.m_26015_());
            }
        });
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)creeper.f_21345_).m_25363_(arg_0));
        CompoundTag persistentData = creeper.getPersistentData();
        boolean walkingFuse = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:walking_fuse", creeper.f_19853_.f_46441_.nextDouble() < this.walkingFuseChance);
        boolean ignoreWalls = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:ignore_walls", creeper.f_19853_.f_46441_.nextDouble() < this.ignoreWalls);
        boolean breach = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:breach", creeper.f_19853_.f_46441_.nextDouble() < this.breach);
        boolean launch = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:launch", creeper.f_19853_.f_46441_.nextDouble() < this.launch);
        boolean cena = NBTUtils.getBooleanOrPutDefault(persistentData, "enhancedai:cena", creeper.f_19853_.f_46441_.nextDouble() < this.cenaChance);
        if (cena) {
            creeper.m_6593_((Component)new TextComponent("Creeper Cena"));
            CompoundTag compoundNBT = new CompoundTag();
            creeper.m_7380_(compoundNBT);
            compoundNBT.m_128376_("Fuse", (short)36);
            compoundNBT.m_128344_("ExplosionRadius", (byte)this.cenaExplosionPower);
            creeper.m_7378_(compoundNBT);
            if (this.cenaFire) {
                persistentData.m_128379_("insanelib:explosion_causes_fire", true);
            }
        }
        AICreeperSwellGoal swellGoal = new AICreeperSwellGoal(creeper).setWalkingFuse(walkingFuse).setIgnoreWalls(ignoreWalls).setBreaching(breach);
        creeper.f_21345_.m_25352_(2, (Goal)swellGoal);
        if (launch) {
            creeper.f_21345_.m_25352_(1, (Goal)new AICreeperLaunchGoal(creeper));
        }
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        Creeper creeper;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !event.getSource().m_19372_() || !((livingEntity = event.getEntityLiving()) instanceof Creeper)) break block2;
                creeper = (Creeper)livingEntity;
                if (this.tntLike) break block3;
            }
            return;
        }
        creeper.m_32312_();
    }
}

